/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.client.texture;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.textures.ITextureAtlasSpriteLoader;
import nikita488.zycraft.ZYCraft;
import nikita488.zycraft.util.IntBiConsumer;

public class CloudSprite
extends TextureAtlasSprite {
    public static final RenderMaterial MATERIAL = ModelLoaderRegistry.blockMaterial((ResourceLocation)ZYCraft.id("cloud"));
    private static final int[] OFFSETS = new int[]{0, -1, 0, 1};
    private static final Random RANDOM = new Random();
    private final float[] pixels;
    private final float[] baseLayer;
    private final float[] adjustmentLayer;

    protected CloudSprite(AtlasTexture atlas, TextureAtlasSprite.Info info, int mipMapLevel, int atlasWidth, int atlasHeight, int x, int y, NativeImage image) {
        super(atlas, info, 0, atlasWidth, atlasHeight, x, y, image);
        this.pixels = new float[info.func_229250_b_() * info.func_229252_c_()];
        this.baseLayer = new float[info.func_229250_b_() * info.func_229252_c_()];
        this.adjustmentLayer = new float[info.func_229250_b_() * info.func_229252_c_()];
    }

    public boolean func_130098_m() {
        return true;
    }

    private void calculate(int x, int y) {
        float pixelsSum = -0.05f;
        int pixelIndex = this.pixelIndex(x, y);
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = y - 1; j <= y + 1; ++j) {
                pixelsSum += this.pixel(this.pixels, i + OFFSETS[y & 3], j + OFFSETS[x & 3]);
            }
        }
        this.pixels[pixelIndex] = pixelsSum * 0.1f + this.average(x, y) * 0.8f;
        int n = pixelIndex;
        this.baseLayer[n] = this.baseLayer[n] + this.adjustmentLayer[pixelIndex] * 0.01f;
        this.baseLayer[pixelIndex] = Math.max(0.0f, this.baseLayer[pixelIndex]);
        int n2 = pixelIndex;
        this.adjustmentLayer[n2] = this.adjustmentLayer[n2] - 0.062f;
        if (RANDOM.nextFloat() < 0.0062f) {
            this.adjustmentLayer[pixelIndex] = 1.33f;
        }
    }

    private float average(int x, int y) {
        return (this.pixel(this.baseLayer, x, y) + this.pixel(this.baseLayer, x + 1, y) + this.pixel(this.baseLayer, x + 1, y + 1) + this.pixel(this.baseLayer, x, y + 1)) * 0.25f;
    }

    private void set(int x, int y) {
        int color = (int)(MathHelper.func_76131_a((float)(this.pixel(this.pixels, x, y) * 2.0f), (float)0.0f, (float)1.0f) * 255.0f);
        this.field_195670_c[0].func_195700_a(x, y, NativeImage.func_227787_a_((int)255, (int)color, (int)color, (int)color));
    }

    private float pixel(float[] pixels, int x, int y) {
        return pixels[this.pixelIndex(x, y)];
    }

    private int pixelIndex(int x, int y) {
        int mask = this.field_229226_c_.func_229250_b_() - 1;
        return (x & mask) + (y & mask) * this.field_229226_c_.func_229250_b_();
    }

    private void forEachPixel(IntBiConsumer consumer) {
        for (int x = 0; x < this.field_229226_c_.func_229250_b_(); ++x) {
            for (int y = 0; y < this.field_229226_c_.func_229252_c_(); ++y) {
                consumer.accept(x, y);
            }
        }
    }

    public void func_94219_l() {
        ++this.field_110983_h;
        this.forEachPixel(this::calculate);
        this.forEachPixel(this::set);
        this.func_195663_q();
    }

    public void close() {
        for (int i = 1; i < this.field_195670_c.length; ++i) {
            this.field_195670_c[i].close();
        }
    }

    public static class Loader
    implements ITextureAtlasSpriteLoader {
        @Nonnull
        public TextureAtlasSprite load(AtlasTexture atlas, IResourceManager manager, TextureAtlasSprite.Info info, IResource resource, int atlasWidth, int atlasHeight, int spriteX, int spriteY, int mipMapLevel, NativeImage image) {
            return new CloudSprite(atlas, info, mipMapLevel, atlasWidth, atlasHeight, spriteX, spriteY, (NativeImage)Util.func_200696_a((Object)new NativeImage(image.func_195702_a(), image.func_195714_b(), false), NativeImage::func_195711_f));
        }
    }
}

