/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.client.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class FluidContainerModel
implements IModelGeometry<FluidContainerModel> {
    private final BlockModel model;
    private final ObjectList<String> fluidTextures;
    @Nullable
    private final ResourceLocation replacementTexture;

    public FluidContainerModel(BlockModel model, ObjectList<String> fluidTextures) {
        this(model, fluidTextures, null);
    }

    public FluidContainerModel(BlockModel model, ObjectList<String> fluidTextures, @Nullable ResourceLocation replacementTexture) {
        this.model = model;
        this.fluidTextures = fluidTextures;
        this.replacementTexture = replacementTexture;
    }

    public FluidContainerModel wrapModel(BlockModel model, ResourceLocation replacementTexture) {
        return new FluidContainerModel(model, this.fluidTextures, replacementTexture);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transform, ItemOverrideList overrides, ResourceLocation location) {
        if (this.replacementTexture == null) {
            return new Baked(this.model.func_228813_a_(bakery, this.model, spriteGetter, transform, location, true), new ItemOverrides(this, bakery, (IUnbakedModel)this.model, this.model.func_187966_f()));
        }
        HashMap<String, Either> textures = new HashMap<String, Either>(this.model.field_178318_c);
        for (String textureName : this.fluidTextures) {
            if (!this.model.func_178300_b(textureName)) continue;
            textures.put(textureName, Either.left((Object)ModelLoaderRegistry.blockMaterial((ResourceLocation)this.replacementTexture)));
        }
        BlockModel wrappedModel = new BlockModel(null, Collections.emptyList(), textures, false, null, ItemCameraTransforms.field_178357_a, Collections.emptyList());
        wrappedModel.field_178315_d = this.model;
        return wrappedModel.func_228813_a_(bakery, wrappedModel, spriteGetter, transform, location, true);
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.func_225614_a_(modelGetter, missingTextureErrors);
    }

    private static class ItemOverrides
    extends ItemOverrideList {
        private final FluidContainerModel parent;
        private final ModelBakery bakery;
        private final IUnbakedModel emptyModel;
        private final ItemOverride[] overrides;
        private final Object2ObjectMap<ResourceLocation, IBakedModel[]> overrideModels = new Object2ObjectOpenHashMap();

        public ItemOverrides(FluidContainerModel parent, ModelBakery bakery, IUnbakedModel emptyModel, List<ItemOverride> overrides) {
            this.parent = parent;
            this.bakery = bakery;
            this.emptyModel = emptyModel;
            this.overrides = new ItemOverride[overrides.size()];
            int i = 0;
            int j = overrides.size() - 1;
            while (i < overrides.size()) {
                this.overrides[i] = overrides.get(j);
                ++i;
                --j;
            }
        }

        @Nullable
        public IBakedModel func_239290_a_(IBakedModel emptyModel, ItemStack stack, @Nullable ClientWorld level, @Nullable LivingEntity entity) {
            if (this.overrides.length == 0) {
                return emptyModel;
            }
            FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
            ResourceLocation id = fluidStack.getFluid().getRegistryName();
            if (fluidStack.isEmpty() || id == null) {
                return emptyModel;
            }
            FluidAttributes attributes = fluidStack.getFluid().getAttributes();
            ResourceLocation texture = attributes.getStillTexture(fluidStack);
            IBakedModel[] models = (IBakedModel[])this.overrideModels.computeIfAbsent((Object)id, key -> {
                IBakedModel[] wrappedModels = new IBakedModel[this.overrides.length];
                ModelRotation rotation = attributes.isLighterThanAir() ? ModelRotation.X180_Y0 : ModelRotation.X0_Y0;
                for (int i = 0; i < this.overrides.length; ++i) {
                    ItemOverride override = this.overrides[i];
                    IUnbakedModel model = this.bakery.func_209597_a(override.func_188026_a());
                    if (Objects.equals(model, this.emptyModel) || !(model instanceof BlockModel)) continue;
                    wrappedModels[i] = this.parent.wrapModel((BlockModel)model, texture).bake(null, this.bakery, ModelLoader.defaultTextureGetter(), (IModelTransform)rotation, this, override.func_188026_a());
                }
                return wrappedModels;
            });
            for (int i = 0; i < this.overrides.length; ++i) {
                if (!this.overrides[i].func_239289_a_(stack, level, entity)) continue;
                IBakedModel model = models[i];
                return model != null ? model : emptyModel;
            }
            return emptyModel;
        }
    }

    public static class Loader
    implements IModelLoader<FluidContainerModel> {
        public static final Loader INSTANCE = new Loader();

        public void func_195410_a(IResourceManager manager) {
        }

        public FluidContainerModel read(JsonDeserializationContext ctx, JsonObject data) {
            BlockModel model = (BlockModel)JSONUtils.func_188174_a((JsonObject)data, (String)"model", (JsonDeserializationContext)ctx, BlockModel.class);
            JsonArray array = JSONUtils.func_151214_t((JsonObject)data, (String)"fluid_textures");
            if (array.size() == 0) {
                throw new JsonParseException("Expected at least 1 fluid texture, got 0");
            }
            ObjectArrayList fluidTextures = new ObjectArrayList();
            for (JsonElement element : array) {
                fluidTextures.add((Object)JSONUtils.func_151206_a((JsonElement)element, (String)"texture"));
            }
            return new FluidContainerModel(model, (ObjectList<String>)fluidTextures);
        }
    }

    private static class Baked
    extends BakedModelWrapper<IBakedModel> {
        private final ItemOverrideList overrides;

        public Baked(IBakedModel model, ItemOverrideList overrides) {
            super(model);
            this.overrides = overrides;
        }

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }
    }
}

