/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import nikita488.zycraft.block.state.properties.ItemIOMode;
import nikita488.zycraft.client.ZYClientSetup;
import nikita488.zycraft.client.gui.GuiComponent;
import nikita488.zycraft.client.texture.CloudSprite;
import nikita488.zycraft.client.texture.GuiComponentManager;
import nikita488.zycraft.init.ZYLang;
import nikita488.zycraft.menu.data.FluidMenuData;
import nikita488.zycraft.menu.data.IOMenuData;
import nikita488.zycraft.menu.data.IntMenuData;
import nikita488.zycraft.menu.slot.IOSlotOverlay;
import nikita488.zycraft.util.Color;

public abstract class ZYScreen<T extends Container>
extends ContainerScreen<T> {
    protected int titleColor = 0x999999;
    protected int playerInventoryTitleColor = 0x999999;

    public ZYScreen(T menu, PlayerInventory inventory, ITextComponent title) {
        super(menu, inventory, title);
        this.field_146999_f = 192;
        this.field_147000_g = 182;
        this.field_238743_q_ = 14;
        this.field_238744_r_ = 16;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_238742_p_ = (this.field_146999_f - this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_)) / 2;
        this.field_238745_s_ = this.field_147000_g - 102;
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(stack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack stack, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(stack, this.field_230704_d_, (float)this.field_238742_p_, (float)this.field_238743_q_, this.titleColor);
        this.field_230712_o_.func_243248_b(stack, this.field_213127_e.func_145748_c_(), (float)this.field_238744_r_, (float)this.field_238745_s_, this.playerInventoryTitleColor);
        for (Widget widget : this.field_230710_m_) {
            if (!widget.func_230449_g_()) continue;
            widget.func_230443_a_(stack, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            break;
        }
    }

    public void renderGUI(MatrixStack stack, ResourceLocation texture, int argb) {
        this.renderBackground(stack, this.field_147003_i + 8, this.field_147009_r + this.field_147000_g - 8, this.field_146999_f - 16, this.field_147000_g - 16, argb);
        this.bindTexture(texture);
        this.func_238474_b_(stack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void renderBackground(MatrixStack stack, int x, int y, int width, int height, int argb) {
        ZYScreen.setColor(argb);
        this.bindTexture(AtlasTexture.field_110575_b);
        this.renderTileableSprite(stack, x, y, CloudSprite.MATERIAL.func_229314_c_(), 32, width, height);
        ZYScreen.setColor(0x434343, 255);
        this.bindTexture(GuiComponentManager.ATLAS_ID);
        this.renderTileableSprite(stack, x, y, ZYClientSetup.guiComponentManager().get(GuiComponent.BACKGROUND), 32, width, height);
        ZYScreen.resetColor();
    }

    public void renderSprite(MatrixStack stack, int x, int y, int width, int height, TextureAtlasSprite sprite) {
        ZYScreen.func_238470_a_((MatrixStack)stack, (int)x, (int)y, (int)this.func_230927_p_(), (int)width, (int)height, (TextureAtlasSprite)sprite);
    }

    public void renderGuiComponent(MatrixStack stack, int x, int y, GuiComponent component) {
        ZYScreen.renderGuiComponent(stack, x, y, this.func_230927_p_(), component.width(), component.height(), component);
    }

    public void renderGuiComponent(MatrixStack stack, int x, int y, int width, int height, GuiComponent component) {
        ZYScreen.renderGuiComponent(stack, x, y, this.func_230927_p_(), width, height, component);
    }

    public void renderGuiComponentWithColor(MatrixStack stack, int x, int y, float resolution, GuiComponent component, int argb) {
        this.renderGuiComponentWithColor(stack, x, y, this.func_230927_p_(), resolution, component, argb);
    }

    public void renderFluid(MatrixStack stack, int x, int y, FluidStack fluid, int resolution, int width, int height, float density) {
        ZYScreen.renderFluid(stack, x, y, this.func_230927_p_(), fluid, resolution, width, height, density);
    }

    public void renderTileableSprite(MatrixStack stack, int x, int y, TextureAtlasSprite sprite, int resolution, int width, int height) {
        ZYScreen.renderTileableSprite(stack, x, y, this.func_230927_p_(), sprite, resolution, width, height);
    }

    public TextureAtlasSprite getSprite(ResourceLocation atlasID, ResourceLocation spriteID) {
        return (TextureAtlasSprite)this.field_230706_i_.func_228015_a_(atlasID).apply(spriteID);
    }

    public void bindTexture(ResourceLocation textureID) {
        this.field_230706_i_.func_110434_K().func_110577_a(textureID);
    }

    public static void resetColor() {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void setColor(int rgb, int a) {
        ZYScreen.setColor(Color.argb(rgb, a));
    }

    public static void setColor(int argb) {
        RenderSystem.color4f((float)((float)(argb >> 16 & 0xFF) / 255.0f), (float)((float)(argb >> 8 & 0xFF) / 255.0f), (float)((float)(argb & 0xFF) / 255.0f), (float)((float)(argb >> 24 & 0xFF) / 255.0f));
    }

    public static void renderGuiComponent(MatrixStack stack, int x, int y, int blitOffset, GuiComponent component) {
        ZYScreen.renderGuiComponent(stack, x, y, blitOffset, component.width(), component.height(), component);
    }

    public static void renderGuiComponent(MatrixStack stack, int x, int y, int blitOffset, int width, int height, GuiComponent component) {
        ZYScreen.func_238470_a_((MatrixStack)stack, (int)x, (int)y, (int)blitOffset, (int)width, (int)height, (TextureAtlasSprite)ZYClientSetup.guiComponentManager().get(component));
    }

    public void renderGuiComponentWithColor(MatrixStack stack, int x, int y, int blitOffset, float resolution, GuiComponent component, int argb) {
        ZYScreen.setColor(argb);
        ZYScreen.renderGuiComponent(stack, x, y, blitOffset, (int)((float)component.width() * resolution), (int)((float)component.height() * resolution), component);
        ZYScreen.resetColor();
    }

    public static void renderFluid(MatrixStack stack, int x, int y, int blitOffset, FluidStack fluid, int resolution, int width, int height, float density) {
        y += height;
        if (fluid.isEmpty()) {
            return;
        }
        FluidAttributes attributes = fluid.getFluid().getAttributes();
        int color = attributes.getColor(fluid);
        if (attributes.isGaseous(fluid)) {
            color = Color.argb(color, (int)(Math.pow(density, 0.4f) * 255.0));
        } else {
            height = (int)((float)height * density);
        }
        ZYScreen.setColor(color);
        ZYScreen.renderTileableSprite(stack, x, y, blitOffset, ModelLoaderRegistry.blockMaterial((ResourceLocation)attributes.getStillTexture(fluid)).func_229314_c_(), resolution, width, height);
        ZYScreen.resetColor();
    }

    public static void renderTileableSprite(MatrixStack stack, int x, int y, int blitOffset, TextureAtlasSprite sprite, int resolution, int width, int height) {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        float u1 = sprite.func_94209_e();
        float v2 = sprite.func_94210_h();
        stack.func_227860_a_();
        stack.func_227861_a_((double)x, (double)y, (double)blitOffset);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        for (int quadX = 0; quadX < width; quadX += resolution) {
            for (int quadY = 0; quadY < height; quadY += resolution) {
                int quadWidth = Math.min(width - quadX, resolution);
                int quadHeight = Math.min(height - quadY, resolution);
                float u2 = u1 + (sprite.func_94212_f() - u1) * (float)quadWidth / (float)resolution;
                float v1 = v2 - (v2 - sprite.func_94206_g()) * (float)quadHeight / (float)resolution;
                buffer.func_227888_a_(matrix, (float)quadX, (float)(-quadY - quadHeight), 0.0f).func_225583_a_(u1, v1).func_181675_d();
                buffer.func_227888_a_(matrix, (float)quadX, (float)(-quadY), 0.0f).func_225583_a_(u1, v2).func_181675_d();
                buffer.func_227888_a_(matrix, (float)(quadX + quadWidth), (float)(-quadY), 0.0f).func_225583_a_(u2, v2).func_181675_d();
                buffer.func_227888_a_(matrix, (float)(quadX + quadWidth), (float)(-quadY - quadHeight), 0.0f).func_225583_a_(u2, v1).func_181675_d();
            }
        }
        Tessellator.func_178181_a().func_78381_a();
        stack.func_227865_b_();
    }

    public static void renderIOSlotOverlays(MatrixStack stack, int x, int y, Iterable<IOSlotOverlay> overlays, IOMenuData ioData) {
        ZYScreen.renderIOSlotOverlays(stack, x, y, overlays, ioData, 128);
    }

    public static void renderIOSlotOverlays(MatrixStack stack, int x, int y, Iterable<IOSlotOverlay> overlays, IOMenuData ioData, int alpha) {
        int slotSize = 16;
        for (IOSlotOverlay overlay : overlays) {
            Iterator iterator = ((AbstractCollection)ioData.get()).iterator();
            while (iterator.hasNext()) {
                ItemIOMode mode = (ItemIOMode)((Object)iterator.next());
                if (!overlay.canBeRendered(mode)) continue;
                int overlayX = x + overlay.x();
                int overlayY = y + overlay.y();
                int offsetX = (overlay.width() - slotSize) / 2;
                int offsetY = (overlay.height() - slotSize) / 2;
                ZYScreen.func_238467_a_((MatrixStack)stack, (int)(overlayX - offsetX), (int)(overlayY - offsetY), (int)(overlayX + slotSize + offsetX), (int)(overlayY + slotSize + offsetY), (int)Color.argb(mode.rgb(), alpha));
            }
        }
    }

    public class FluidGaugeWidget
    extends Widget {
        private final FluidMenuData fluidData;
        private final int capacity;

        public FluidGaugeWidget(int x, int y, FluidMenuData fluidData, int capacity) {
            super(x, y, GuiComponent.BIG_TANK.width(), GuiComponent.BIG_TANK.height(), StringTextComponent.field_240750_d_);
            this.fluidData = fluidData;
            this.capacity = capacity;
        }

        public boolean func_230449_g_() {
            return !this.fluidData.get().isEmpty() && this.capacity > 0 && super.func_230449_g_();
        }

        protected IFormattableTextComponent func_230442_c_() {
            FluidStack fluid = this.fluidData.get();
            return ZYLang.copy(ZYLang.NARRATE_GAUGE, fluid.getDisplayName(), fluid.getAmount(), this.capacity);
        }

        public void func_230988_a_(SoundHandler handler) {
        }

        public void func_230443_a_(MatrixStack pose, int mouseX, int mouseY) {
            FluidStack stack = this.fluidData.get();
            ObjectArrayList tooltip = new ObjectArrayList();
            tooltip.add((Object)stack.getDisplayName());
            tooltip.add((Object)ZYLang.copy(ZYLang.FLUID_TANK_FILLED, stack.getAmount(), this.capacity));
            ZYScreen.this.func_243308_b(pose, (List)tooltip, mouseX, mouseY);
        }

        public void func_230431_b_(MatrixStack pose, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            FluidStack stack = this.fluidData.get();
            ZYScreen.this.bindTexture(GuiComponentManager.ATLAS_ID);
            ZYScreen.this.renderGuiComponent(pose, this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_, GuiComponent.BIG_TANK_BACKGROUND);
            ZYScreen.this.bindTexture(AtlasTexture.field_110575_b);
            if (!stack.isEmpty() && this.capacity > 0) {
                ZYScreen.this.renderFluid(pose, this.field_230690_l_ + 3, this.field_230691_m_ + 3, stack, 16, this.field_230688_j_ - 6, this.field_230689_k_ - 6, (float)stack.getAmount() / (float)this.capacity);
            }
            ZYScreen.this.bindTexture(GuiComponentManager.ATLAS_ID);
            ZYScreen.this.renderGuiComponent(pose, this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_, GuiComponent.BIG_TANK_GAUGE);
            ZYScreen.this.renderGuiComponent(pose, this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_, GuiComponent.BIG_TANK);
            RenderSystem.disableBlend();
        }
    }

    public class Menu
    implements IRenderable {
        private final int x;
        private final int y;
        private final int selectedColor;
        private final IntMenuData selectedItem;
        private int itemCount;

        public Menu(int x, int y, int selectedColor, IntMenuData selectedItem) {
            this.x = x;
            this.y = y;
            this.selectedColor = selectedColor;
            this.selectedItem = selectedItem;
        }

        public Menu addItem(ITextComponent tooltip, ResourceLocation iconName) {
            ZYScreen.this.func_230480_a_((Widget)new Item(this.x + 6, this.y + 5 + GuiComponent.MENU_MIDDLE.height() * this.itemCount, tooltip, this.itemCount, iconName));
            ++this.itemCount;
            return this;
        }

        public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
            ZYScreen.resetColor();
            ZYScreen.this.renderGuiComponent(stack, this.x, this.y, GuiComponent.MENU_TOP);
            for (int item = 0; item < this.itemCount; ++item) {
                ZYScreen.this.renderGuiComponent(stack, this.x, this.y + 5 + item * GuiComponent.MENU_MIDDLE.height(), GuiComponent.MENU_MIDDLE);
            }
            ZYScreen.this.renderGuiComponent(stack, this.x, this.y + 5 + GuiComponent.MENU_MIDDLE.height() * this.itemCount, GuiComponent.MENU_BOTTOM);
        }

        private class Item
        extends AbstractButton {
            private final int index;
            private final ResourceLocation iconName;

            private Item(int x, int y, ITextComponent tooltip, int index, ResourceLocation iconName) {
                super(x, y, GuiComponent.MENU_ITEM.width(), GuiComponent.MENU_ITEM.height(), tooltip);
                this.index = index;
                this.iconName = iconName;
            }

            public void func_230930_b_() {
                if (ZYScreen.this.field_147002_h.func_75140_a((PlayerEntity)((ZYScreen)ZYScreen.this).field_230706_i_.field_71439_g, this.index)) {
                    ((ZYScreen)ZYScreen.this).field_230706_i_.field_71442_b.func_78756_a(((ZYScreen)ZYScreen.this).field_147002_h.field_75152_c, this.index);
                }
            }

            public void func_230443_a_(MatrixStack stack, int mouseX, int mouseY) {
                ZYScreen.this.func_238652_a_(stack, this.func_230458_i_(), mouseX, mouseY);
            }

            public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
                ResourceLocation blockAtlas = AtlasTexture.field_110575_b;
                if (this.index == Menu.this.selectedItem.getAsInt()) {
                    ZYScreen.setColor(Menu.this.selectedColor, 255);
                    ZYScreen.this.bindTexture(blockAtlas);
                    ZYScreen.this.renderSprite(stack, this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_, CloudSprite.MATERIAL.func_229314_c_());
                }
                ZYScreen.resetColor();
                ZYScreen.this.bindTexture(GuiComponentManager.ATLAS_ID);
                ZYScreen.this.renderGuiComponent(stack, this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_, GuiComponent.MENU_ITEM);
                ZYScreen.this.bindTexture(blockAtlas);
                ZYScreen.this.renderSprite(stack, this.field_230690_l_ + 3, this.field_230691_m_ + 3, 16, 16, ZYScreen.this.getSprite(blockAtlas, this.iconName));
            }
        }
    }
}

