/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.api.colorable;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import nikita488.zycraft.api.colorable.IColorChanger;
import nikita488.zycraft.api.util.ZYDyeColor;

public interface IColorable {
    default public int getColor(BlockState state, IBlockDisplayReader getter, BlockPos pos, int tintIndex) {
        return this.getColor(state, getter, pos);
    }

    public int getColor(BlockState var1, IBlockDisplayReader var2, BlockPos var3);

    public void setColor(BlockState var1, IBlockDisplayReader var2, BlockPos var3, int var4);

    public static boolean isColorable(IBlockReader getter, BlockPos pos) {
        return getter.func_175625_s(pos) instanceof IColorable;
    }

    public static ActionResultType interact(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hitResult) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return ActionResultType.PASS;
        }
        TileEntity blockEntity = level.func_175625_s(pos);
        if (blockEntity instanceof IColorable) {
            IColorable colorable = (IColorable)blockEntity;
            int rgb = colorable.getColor(state, (IBlockDisplayReader)level, pos);
            if (stack.func_77973_b() instanceof IColorChanger) {
                IColorChanger changer = (IColorChanger)stack.func_77973_b();
                if (!changer.canChangeColor(state, level, pos, player, hand, hitResult, rgb)) {
                    return ActionResultType.PASS;
                }
                if (!level.func_201670_d()) {
                    colorable.setColor(state, (IBlockDisplayReader)level, pos, changer.changeColor(state, level, pos, player, hand, hitResult, rgb));
                }
                return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
            }
            ZYDyeColor dyeColor = ZYDyeColor.byDyeColor(stack);
            if (dyeColor == null || rgb == dyeColor.rgb()) {
                return ActionResultType.PASS;
            }
            if (!level.func_201670_d()) {
                colorable.setColor(state, (IBlockDisplayReader)level, pos, dyeColor.rgb());
            }
            return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
        }
        return ActionResultType.CONSUME;
    }
}

