/*
 * Decompiled with CFR 0.152.
 */
package link.infra.demagnetize.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import link.infra.demagnetize.blocks.DemagnetizerTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class Demagnetizer
extends Block {
    private final boolean isAdvanced;

    public Demagnetizer(boolean isAdvanced) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.0f));
        this.isAdvanced = isAdvanced;
        if (isAdvanced) {
            this.setRegistryName("demagnetizer_advanced");
        } else {
            this.setRegistryName("demagnetizer");
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new DemagnetizerTileEntity(this.isAdvanced);
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult result) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof INamedContainerProvider) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
            } else {
                throw new IllegalStateException("Demagnetizer TileEntity invalid in onBlockActivated position!");
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_220069_a(@Nonnull BlockState state, World worldIn, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos neighborPos, boolean isMoving) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof DemagnetizerTileEntity) {
            int powerLevel = worldIn.func_175687_A(pos);
            ((DemagnetizerTileEntity)te).updateRedstone(powerLevel > 0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flagIn) {
        if (stack.func_77978_p() != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.demagnetize.configured").func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY}));
        }
    }

    @Nonnull
    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof DemagnetizerTileEntity) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            CompoundNBT tagCompound = new CompoundNBT();
            CompoundNBT tagCompoundFull = new CompoundNBT();
            te.func_189515_b(tagCompoundFull);
            if (tagCompoundFull.func_74764_b("items")) {
                tagCompound.func_218657_a("items", (INBT)tagCompoundFull.func_74775_l("items"));
            }
            if (tagCompoundFull.func_74764_b("redstone")) {
                tagCompound.func_74778_a("redstone", tagCompoundFull.func_74779_i("redstone"));
            }
            if (tagCompoundFull.func_74764_b("range")) {
                tagCompound.func_74768_a("range", tagCompoundFull.func_74762_e("range"));
            }
            if (tagCompoundFull.func_74764_b("whitelist")) {
                tagCompound.func_74757_a("whitelist", tagCompoundFull.func_74767_n("whitelist"));
            }
            stack.func_77983_a("BlockEntityTag", (INBT)tagCompound);
            return stack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }
}

