/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.common.fabric;

import java.util.Objects;
import net.minecraft.class_2338;

public class CubicChunkPos {
    public final int x;
    public final int y;
    public final int z;

    public CubicChunkPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public CubicChunkPos(long l) {
        this.x = CubicChunkPos.getX(l);
        this.y = CubicChunkPos.getY(l);
        this.z = CubicChunkPos.getZ(l);
    }

    public CubicChunkPos(class_2338 blockPos) {
        this.x = blockPos.method_10263() >> 4;
        this.y = blockPos.method_10264() >> 4;
        this.z = blockPos.method_10260() >> 4;
    }

    public long toLong() {
        return CubicChunkPos.asLong(this.x, this.y, this.z);
    }

    public static long asLong(int x, int y, int z) {
        return ((long)x & 0xFFFFFFL) << 36 | ((long)y & 0xFFFL) << 24 | (long)z & 0xFFFFFFL;
    }

    public static int getX(long l) {
        return (int)(l >> 36 & 0xFFFFFFL);
    }

    public static int getY(long l) {
        return (int)(l >> 24 & 0xFFFL);
    }

    public static int getZ(long l) {
        return (int)(l & 0xFFFFFFL);
    }

    public int getMinBlockX() {
        return this.x << 4;
    }

    public int getMinBlockY() {
        return this.y << 4;
    }

    public int getMinBlockZ() {
        return this.z << 4;
    }

    public int getMaxBlockX() {
        return (this.x << 4) + 15;
    }

    public int getMaxBlockY() {
        return (this.y << 4) + 15;
    }

    public int getMaxBlockZ() {
        return (this.z << 4) + 15;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CubicChunkPos that = (CubicChunkPos)o;
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }
}

