/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class TextField
extends Widget {
    public ITextComponent component = StringTextComponent.field_240750_d_;
    private ITextProperties[] formattedText = new ITextProperties[0];
    public int textFlags = 0;
    public int minWidth = 0;
    public int maxWidth = 5000;
    public int textSpacing = 10;
    public float scale = 1.0f;
    public Color4I textColor = Icon.EMPTY;
    public boolean trim = false;

    public TextField(Panel panel) {
        super(panel);
    }

    public TextField addFlags(int flags) {
        this.textFlags |= flags;
        return this;
    }

    public TextField setMinWidth(int width) {
        this.minWidth = width;
        return this;
    }

    public TextField setMaxWidth(int width) {
        this.maxWidth = width;
        return this;
    }

    public TextField setColor(Color4I color) {
        this.textColor = color;
        return this;
    }

    public TextField setScale(float s) {
        this.scale = s;
        return this;
    }

    public TextField setSpacing(int s) {
        this.textSpacing = s;
        return this;
    }

    public TextField setTrim() {
        this.trim = true;
        return this;
    }

    public TextField setText(ITextComponent txt) {
        Theme theme = this.getGui().getTheme();
        this.formattedText = this.trim ? new ITextProperties[]{theme.trimStringToWidth((ITextProperties)new StringTextComponent("").func_230529_a_(txt), this.maxWidth)} : theme.listFormattedStringToWidth((ITextProperties)new StringTextComponent("").func_230529_a_(txt), this.maxWidth).toArray(new ITextProperties[0]);
        return this.resize(theme);
    }

    public TextField setText(String txt) {
        return this.setText((ITextComponent)new StringTextComponent(txt));
    }

    public TextField resize(Theme theme) {
        this.setWidth(0);
        for (ITextProperties s : this.formattedText) {
            this.setWidth(Math.max(this.width, (int)((float)theme.getStringWidth(s) * this.scale)));
        }
        this.setWidth(MathHelper.func_76125_a((int)this.width, (int)this.minWidth, (int)this.maxWidth));
        this.setHeight((int)((float)(Math.max(1, this.formattedText.length) * this.textSpacing - (this.textSpacing - theme.getFontHeight() + 1)) * this.scale));
        return this;
    }

    @Override
    public void addMouseOverText(TooltipList list) {
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
    }

    @Override
    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        this.drawBackground(matrixStack, theme, x, y, w, h);
        if (this.formattedText.length != 0) {
            boolean centered = Bits.getFlag(this.textFlags, 4);
            boolean centeredV = Bits.getFlag(this.textFlags, 32);
            Color4I col = this.textColor;
            if (col.isEmpty()) {
                col = theme.getContentColor(WidgetType.mouseOver(Bits.getFlag(this.textFlags, 16)));
            }
            int tx = x + (centered ? w / 2 : 0);
            int ty = y + (centeredV ? (h - theme.getFontHeight()) / 2 : 0);
            if (this.scale == 1.0f) {
                for (int i = 0; i < this.formattedText.length; ++i) {
                    theme.drawString(matrixStack, this.formattedText[i], tx, ty + i * this.textSpacing, col, this.textFlags);
                }
            } else {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)tx, (double)ty, 0.0);
                matrixStack.func_227862_a_(this.scale, this.scale, 1.0f);
                for (int i = 0; i < this.formattedText.length; ++i) {
                    theme.drawString(matrixStack, this.formattedText[i], 0.0f, i * this.textSpacing, col, this.textFlags);
                }
                matrixStack.func_227865_b_();
            }
        }
    }
}

