/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.math;

import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class XZ {
    public final int x;
    public final int z;

    public static XZ of(int x, int z) {
        return new XZ(x, z);
    }

    public static XZ of(long singleLong) {
        return XZ.of((int)singleLong, (int)(singleLong >> 32));
    }

    public static XZ of(ChunkPos pos) {
        return XZ.of(pos.field_77276_a, pos.field_77275_b);
    }

    public static XZ chunkFromBlock(int x, int z) {
        return XZ.of(x >> 4, z >> 4);
    }

    public static XZ chunkFromBlock(Vector3i pos) {
        return XZ.chunkFromBlock(pos.func_177958_n(), pos.func_177952_p());
    }

    public static XZ regionFromChunk(int x, int z) {
        return XZ.of(x >> 5, z >> 5);
    }

    public static XZ regionFromChunk(ChunkPos p) {
        return XZ.of(p.field_77276_a >> 5, p.field_77275_b >> 5);
    }

    public static XZ regionFromBlock(int x, int z) {
        return XZ.of(x >> 9, z >> 9);
    }

    public static XZ regionFromBlock(Vector3i pos) {
        return XZ.regionFromBlock(pos.func_177958_n(), pos.func_177952_p());
    }

    private XZ(int _x, int _z) {
        this.x = _x;
        this.z = _z;
    }

    public int hashCode() {
        int x1 = 1664525 * this.x + 1013904223;
        int z1 = 1664525 * (this.z ^ 0xDEADBEEF) + 1013904223;
        return x1 ^ z1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XZ)) {
            return false;
        }
        XZ p = (XZ)o;
        return this.x == p.x && this.z == p.z;
    }

    public String toString() {
        return "[" + this.x + ", " + this.z + "]";
    }

    public ChunkDimPos dim(RegistryKey<World> type) {
        return new ChunkDimPos(type, this.x, this.z);
    }

    public ChunkDimPos dim(World world) {
        return this.dim((RegistryKey<World>)world.func_234923_W_());
    }

    public XZ offset(int ox, int oz) {
        return XZ.of(this.x + ox, this.z + oz);
    }

    public long toLong() {
        return ChunkPos.func_77272_a((int)this.x, (int)this.z);
    }

    public String toRegionString() {
        return String.format("%05X-%05X", this.x + 60000, this.z + 60000);
    }
}

