/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.rangedpumps.tile;

import com.refinedmods.rangedpumps.RangedPumps;
import com.refinedmods.rangedpumps.tile.PumpState;
import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;

public class PumpTile
extends TileEntity
implements ITickableTileEntity {
    @ObjectHolder(value="rangedpumps:pump")
    public static final TileEntityType<PumpTile> TYPE = null;
    private PumpTank tank = new PumpTank();
    private IEnergyStorage energy = new EnergyStorage(RangedPumps.SERVER_CONFIG.getEnergyCapacity());
    private final LazyOptional<IEnergyStorage> energyProxyCap = LazyOptional.of(() -> this.energy);
    private final LazyOptional<IFluidHandler> fluidHandlerCap = LazyOptional.of(() -> this.tank);
    private int ticks;
    @Nullable
    private BlockPos currentPos;
    private int range = -1;
    private Queue<BlockPos> surfaces = new LinkedList<BlockPos>();
    private Block blockToReplaceLiquidsWith;

    public PumpTile() {
        super(TYPE);
    }

    private void rebuildSurfaces() {
        int i;
        this.surfaces.clear();
        if (this.range == -1) {
            this.surfaces.add(this.field_174879_c.func_177977_b());
            return;
        }
        int hl = 3 + 2 * this.range;
        int vl = 1 + 2 * this.range;
        for (i = 0; i < hl; ++i) {
            this.surfaces.add(this.field_174879_c.func_177982_a(-this.range - 1 + i, -1, -this.range - 1));
        }
        for (i = 0; i < vl; ++i) {
            this.surfaces.add(this.field_174879_c.func_177982_a(-this.range - 1 + vl + 1, -1, -this.range - 1 + i + 1));
        }
        for (i = 0; i < hl; ++i) {
            this.surfaces.add(this.field_174879_c.func_177982_a(-this.range - 1 + hl - i - 1, -1, -this.range - 1 + hl - 1));
        }
        for (i = 0; i < vl; ++i) {
            this.surfaces.add(this.field_174879_c.func_177982_a(-this.range - 1, -1, -this.range - 1 + vl - i));
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.surfaces.isEmpty()) {
            this.rebuildSurfaces();
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!RangedPumps.SERVER_CONFIG.getUseEnergy()) {
            this.energy.receiveEnergy(this.energy.getMaxEnergyStored(), false);
        }
        if (!this.tank.getFluid().isEmpty()) {
            LinkedList<IFluidHandler> fluidHandlers = new LinkedList<IFluidHandler>();
            for (Direction facing : Direction.values()) {
                IFluidHandler handler;
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (tile == null || (handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()).orElse(null)) == null) continue;
                fluidHandlers.add(handler);
            }
            if (!fluidHandlers.isEmpty()) {
                int transfer = (int)Math.floor((float)this.tank.getFluidAmount() / (float)fluidHandlers.size());
                for (IFluidHandler fluidHandler : fluidHandlers) {
                    FluidStack toFill = this.tank.getFluid().copy();
                    toFill.setAmount(transfer);
                    this.tank.drain(fluidHandler.fill(toFill, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
        if ((RangedPumps.SERVER_CONFIG.getSpeed() == 0 || this.ticks % RangedPumps.SERVER_CONFIG.getSpeed() == 0) && this.getState() == PumpState.WORKING) {
            if (this.currentPos == null || this.currentPos.func_177956_o() == 0) {
                if (this.surfaces.isEmpty()) {
                    ++this.range;
                    if (this.range > RangedPumps.SERVER_CONFIG.getRange()) {
                        return;
                    }
                    this.rebuildSurfaces();
                }
                this.currentPos = this.surfaces.poll();
            } else {
                this.currentPos = this.currentPos.func_177977_b();
            }
            this.energy.extractEnergy(RangedPumps.SERVER_CONFIG.getEnergyUsagePerMove(), false);
            FluidStack drained = this.drainAt(this.currentPos, IFluidHandler.FluidAction.SIMULATE);
            if (!drained.isEmpty() && this.tank.fillInternal(drained, IFluidHandler.FluidAction.SIMULATE) == drained.getAmount() && !(drained = this.drainAt(this.currentPos, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
                this.tank.fillInternal(drained, IFluidHandler.FluidAction.EXECUTE);
                if (RangedPumps.SERVER_CONFIG.getReplaceLiquidWithBlock()) {
                    if (this.blockToReplaceLiquidsWith == null) {
                        this.blockToReplaceLiquidsWith = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(RangedPumps.SERVER_CONFIG.getBlockIdToReplaceLiquidsWith()));
                    }
                    if (this.blockToReplaceLiquidsWith != null) {
                        this.field_145850_b.func_175656_a(this.currentPos, this.blockToReplaceLiquidsWith.func_176223_P());
                    }
                }
                this.energy.extractEnergy(RangedPumps.SERVER_CONFIG.getEnergyUsagePerDrain(), false);
            }
            this.func_70296_d();
        }
        ++this.ticks;
    }

    @Nonnull
    private FluidStack drainAt(BlockPos pos, IFluidHandler.FluidAction action) {
        IFluidBlock fluidBlock;
        BlockState frontBlockState = this.field_145850_b.func_180495_p(pos);
        Block frontBlock = frontBlockState.func_177230_c();
        if (frontBlock instanceof FlowingFluidBlock) {
            if ((Integer)frontBlockState.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0) {
                FlowingFluid fluid = ((FlowingFluidBlock)frontBlock).getFluid();
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.field_145850_b.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
                }
                return new FluidStack((Fluid)fluid, 1000);
            }
        } else if (frontBlock instanceof IFluidBlock && (fluidBlock = (IFluidBlock)frontBlock).canDrain(this.field_145850_b, pos)) {
            return fluidBlock.drain(this.field_145850_b, pos, action);
        }
        return FluidStack.EMPTY;
    }

    BlockPos getCurrentPosition() {
        return this.currentPos == null ? this.field_174879_c.func_177977_b() : this.currentPos;
    }

    int getRange() {
        return this.range;
    }

    PumpState getState() {
        if (this.range > RangedPumps.SERVER_CONFIG.getRange()) {
            return PumpState.DONE;
        }
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return PumpState.REDSTONE;
        }
        if (this.energy.getEnergyStored() == 0) {
            return PumpState.ENERGY;
        }
        if (this.tank.getFluidAmount() > this.tank.getCapacity() - 1000) {
            return PumpState.FULL;
        }
        return PumpState.WORKING;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("Energy", this.energy.getEnergyStored());
        if (this.currentPos != null) {
            tag.func_74772_a("CurrentPos", this.currentPos.func_218275_a());
        }
        tag.func_74768_a("Range", this.range);
        ListNBT surfaces = new ListNBT();
        this.surfaces.forEach(s -> surfaces.add((Object)LongNBT.func_229698_a_((long)s.func_218275_a())));
        tag.func_218657_a("Surfaces", (INBT)surfaces);
        this.tank.writeToNBT(tag);
        return tag;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT tag) {
        super.func_230337_a_(blockState, tag);
        if (tag.func_74764_b("Energy")) {
            this.energy.receiveEnergy(tag.func_74762_e("Energy"), false);
        }
        if (tag.func_74764_b("CurrentPos")) {
            this.currentPos = BlockPos.func_218283_e((long)tag.func_74763_f("CurrentPos"));
        }
        if (tag.func_74764_b("Range")) {
            this.range = tag.func_74762_e("Range");
        }
        if (tag.func_74764_b("Surfaces")) {
            ListNBT surfaces = tag.func_150295_c("Surfaces", 4);
            for (INBT surface : surfaces) {
                this.surfaces.add(BlockPos.func_218283_e((long)((LongNBT)surface).func_150291_c()));
            }
        }
        this.tank.readFromNBT(tag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyProxyCap.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandlerCap.cast();
        }
        return super.getCapability(cap, direction);
    }

    private class PumpTank
    extends FluidTank {
        public PumpTank() {
            super(RangedPumps.SERVER_CONFIG.getTankCapacity());
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public int fillInternal(FluidStack resource, IFluidHandler.FluidAction action) {
            return super.fill(resource, action);
        }
    }
}

