/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.provider.deserializers.value;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.valkyrieofnight.vlib.core.io.json.JsonUtils;
import com.valkyrieofnight.vlib.registry.conditiondata.base.ConditionID;
import com.valkyrieofnight.vlib.registry.conditiondata.base.ConditionScope;
import com.valkyrieofnight.vlib.registry.provider.deserializers.ProviderDeserializer;
import com.valkyrieofnight.vlib.registry.provider.value.ValueProvider;
import java.lang.reflect.Type;

public class ValueProviderDeserializers {
    public static final String TYPE = "condition";
    public static final String SCOPE_KEY = "scope";
    public static final String DEFAULT_VALUE_KEY = "default";
    public static final ProviderDeserializer<ValueProvider.Boolean> BOOLEAN = new ProviderDeserializer<ValueProvider.Boolean>(ValueProvider.Boolean.class, "condition:boolean"){

        public ValueProvider.Boolean deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                ConditionID id = ValueProviderDeserializers.getID(jo);
                String scope = JsonUtils.getAsString(jo, ValueProviderDeserializers.SCOPE_KEY);
                boolean dv = JsonUtils.getAsBoolean(jo, ValueProviderDeserializers.DEFAULT_VALUE_KEY);
                if (id != null) {
                    ConditionScope conditionScope = ConditionScope.getByName(scope);
                    return new ValueProvider.Boolean(id, conditionScope != null ? conditionScope : ConditionScope.GLOBAL, dv);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<ValueProvider.Byte> BYTE = new ProviderDeserializer<ValueProvider.Byte>(ValueProvider.Byte.class, "condition:byte"){

        public ValueProvider.Byte deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                ConditionID id = ValueProviderDeserializers.getID(jo);
                String scope = JsonUtils.getAsString(jo, ValueProviderDeserializers.SCOPE_KEY);
                byte dv = JsonUtils.getAsByte(jo, ValueProviderDeserializers.DEFAULT_VALUE_KEY);
                if (id != null) {
                    ConditionScope conditionScope = ConditionScope.getByName(scope);
                    return new ValueProvider.Byte(id, conditionScope != null ? conditionScope : ConditionScope.GLOBAL, dv);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<ValueProvider.Short> SHORT = new ProviderDeserializer<ValueProvider.Short>(ValueProvider.Short.class, "condition:short"){

        public ValueProvider.Short deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                ConditionID id = ValueProviderDeserializers.getID(jo);
                String scope = JsonUtils.getAsString(jo, ValueProviderDeserializers.SCOPE_KEY);
                short dv = JsonUtils.getAsShort(jo, ValueProviderDeserializers.DEFAULT_VALUE_KEY);
                if (id != null) {
                    ConditionScope conditionScope = ConditionScope.getByName(scope);
                    return new ValueProvider.Short(id, conditionScope != null ? conditionScope : ConditionScope.GLOBAL, dv);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<ValueProvider.Int> INT = new ProviderDeserializer<ValueProvider.Int>(ValueProvider.Int.class, "condition:int"){

        public ValueProvider.Int deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                ConditionID id = ValueProviderDeserializers.getID(jo);
                String scope = JsonUtils.getAsString(jo, ValueProviderDeserializers.SCOPE_KEY);
                int dv = JsonUtils.getAsInt(jo, ValueProviderDeserializers.DEFAULT_VALUE_KEY);
                if (id != null) {
                    ConditionScope conditionScope = ConditionScope.getByName(scope);
                    return new ValueProvider.Int(id, conditionScope != null ? conditionScope : ConditionScope.GLOBAL, dv);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<ValueProvider.Long> LONG = new ProviderDeserializer<ValueProvider.Long>(ValueProvider.Long.class, "condition:long"){

        public ValueProvider.Long deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                ConditionID id = ValueProviderDeserializers.getID(jo);
                String scope = JsonUtils.getAsString(jo, ValueProviderDeserializers.SCOPE_KEY);
                long dv = JsonUtils.getAsLong(jo, ValueProviderDeserializers.DEFAULT_VALUE_KEY);
                if (id != null) {
                    ConditionScope conditionScope = ConditionScope.getByName(scope);
                    return new ValueProvider.Long(id, conditionScope != null ? conditionScope : ConditionScope.GLOBAL, dv);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<ValueProvider.Float> FLOAT = new ProviderDeserializer<ValueProvider.Float>(ValueProvider.Float.class, "condition:float"){

        public ValueProvider.Float deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                ConditionID id = ValueProviderDeserializers.getID(jo);
                String scope = JsonUtils.getAsString(jo, ValueProviderDeserializers.SCOPE_KEY);
                float dv = JsonUtils.getAsFloat(jo, ValueProviderDeserializers.DEFAULT_VALUE_KEY);
                if (id != null) {
                    ConditionScope conditionScope = ConditionScope.getByName(scope);
                    return new ValueProvider.Float(id, conditionScope != null ? conditionScope : ConditionScope.GLOBAL, Float.valueOf(dv));
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<ValueProvider.Double> DOUBLE = new ProviderDeserializer<ValueProvider.Double>(ValueProvider.Double.class, "condition:double"){

        public ValueProvider.Double deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                ConditionID id = ValueProviderDeserializers.getID(jo);
                String scope = JsonUtils.getAsString(jo, ValueProviderDeserializers.SCOPE_KEY);
                double dv = JsonUtils.getAsDouble(jo, ValueProviderDeserializers.DEFAULT_VALUE_KEY);
                if (id != null) {
                    ConditionScope conditionScope = ConditionScope.getByName(scope);
                    return new ValueProvider.Double(id, conditionScope != null ? conditionScope : ConditionScope.GLOBAL, dv);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<ValueProvider.Char> CHAR = new ProviderDeserializer<ValueProvider.Char>(ValueProvider.Char.class, "condition:char"){

        public ValueProvider.Char deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                ConditionID id = ValueProviderDeserializers.getID(jo);
                String scope = JsonUtils.getAsString(jo, ValueProviderDeserializers.SCOPE_KEY);
                char dv = JsonUtils.getAsChar(jo, ValueProviderDeserializers.DEFAULT_VALUE_KEY);
                if (id != null) {
                    ConditionScope conditionScope = ConditionScope.getByName(scope);
                    return new ValueProvider.Char(id, conditionScope != null ? conditionScope : ConditionScope.GLOBAL, Character.valueOf(dv));
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<ValueProvider.String> STRING = new ProviderDeserializer<ValueProvider.String>(ValueProvider.String.class, "condition:string"){

        public ValueProvider.String deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                ConditionID id = ValueProviderDeserializers.getID(jo);
                String scope = JsonUtils.getAsString(jo, ValueProviderDeserializers.SCOPE_KEY);
                String dv = JsonUtils.getAsString(jo, ValueProviderDeserializers.DEFAULT_VALUE_KEY);
                if (id != null) {
                    ConditionScope conditionScope = ConditionScope.getByName(scope);
                    return new ValueProvider.String(id, conditionScope != null ? conditionScope : ConditionScope.GLOBAL, dv);
                }
            }
            return null;
        }
    };

    public static ConditionID getID(JsonObject jo) {
        if (jo.has("id")) {
            JsonObject vobj = jo.getAsJsonObject("id");
            try {
                String str = vobj.getAsString();
                return ConditionID.fromString(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

