/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.ingredient.fluid;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.obj.TagUtils;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import com.valkyrieofnight.vlib.registry.ingredient.TagIngredient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FluidTagIngredient
extends TagIngredient<FluidStack> {
    private VLID tag;
    private int amount;

    public FluidTagIngredient(@NotNull VLID tag, int amount, Ingredient.TagIngredientType selector) {
        super(selector);
        this.tag = tag;
        this.amount = amount;
    }

    public FluidTagIngredient(@NotNull VLID tag, int amount, Ingredient.TagIngredientType selector, String[] values) {
        super(selector, values);
        this.tag = tag;
        this.amount = amount;
    }

    public FluidTagIngredient(PacketBuffer packet) {
        super(packet);
    }

    @Override
    public int getTotalTagEntries() {
        ITag<Fluid> tag = this.getTag();
        return tag != null ? tag.func_230236_b_().size() : 0;
    }

    private ITag<Fluid> getTag() {
        return TagUtils.getFluidTag(this.tag);
    }

    @Override
    public boolean test(@NotNull ConditionContainerProvider provider, FluidStack test) {
        List<FluidStack> options = this.request(provider);
        for (FluidStack fs : options) {
            if (!fs.isFluidEqual(test)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<FluidStack> request(@NotNull ConditionContainerProvider provider) {
        int amount = this.requestAmount(provider);
        ITag<Fluid> tag = this.getTag();
        if (tag == null) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        switch (this.selector) {
            case ALL_WHITELISTED: {
                if (this.properties.length > 0) {
                    TagUtils.addFluidAllWhitelisted(list, tag, amount, this.properties);
                    break;
                }
                TagUtils.addFluidAll(list, tag, amount);
                break;
            }
            case ALL: {
                TagUtils.addFluidAll(list, tag, amount);
                break;
            }
            case FIRST_WHITELISTED: {
                if (this.properties.length > 0) {
                    TagUtils.addFluidFirstWhitelisted(list, tag, amount, this.properties);
                } else {
                    TagUtils.addFluidFirst(list, tag, amount);
                }
            }
            case FIRST: {
                TagUtils.addFluidFirst(list, tag, amount);
                break;
            }
            case FIRST_PREFERRED: {
                TagUtils.addFluidFirstPreferred(list, tag, amount, this.properties);
                break;
            }
            case FIRST_WITH_BLACKLIST: {
                TagUtils.addFluidFirstWithBlacklist(list, tag, amount, this.properties);
                break;
            }
            case ALL_WITH_BLACKLIST: {
                TagUtils.addFluidAllWithBlacklist(list, tag, amount, this.properties);
            }
        }
        return list;
    }

    @Override
    public int requestAmount(@NotNull ConditionContainerProvider provider) {
        return this.amount;
    }

    @Override
    public void writeOtherPacketData(PacketBuffer buffer) {
        buffer.func_180714_a(FluidTagIngredient.getFromClass(this.getClass()));
        buffer.func_192572_a((ResourceLocation)this.tag);
        buffer.writeInt(this.amount);
    }

    @Override
    public void readOtherPacketData(PacketBuffer buffer) {
        this.tag = VLID.from(buffer.func_192575_l());
        this.amount = buffer.readInt();
    }

    @Override
    public boolean isValid() {
        ITag<Fluid> tag = this.getTag();
        return tag != null && tag.func_230236_b_().size() > 0;
    }

    public String toString() {
        return "{tag:" + this.tag.toString() + ",amount:" + this.amount + "}";
    }
}

