/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.ingredient.block;

import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.modloader.util.RegistryUtils;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.network.PacketBuffer;

public class BlockIngredient
extends Ingredient<Block> {
    private Block block;

    public BlockIngredient(Block block) {
        this.block = block;
    }

    public BlockIngredient(PacketBuffer buffer) {
        super(buffer);
    }

    @Override
    public void writePacketData(PacketBuffer buffer) {
        buffer.func_180714_a(BlockIngredient.getFromClass(this.getClass()));
        buffer.func_192572_a(this.block.getRegistryName());
    }

    @Override
    public void readPacketData(PacketBuffer buffer) {
        RegistryUtils.getBlock(VLID.from(buffer.func_192575_l())).ifPresent(b -> {
            this.block = b;
        });
    }

    @Override
    public boolean test(ConditionContainerProvider provider, Block test) {
        return test != null ? test.equals(this.block) : false;
    }

    @Override
    public List<Block> request(ConditionContainerProvider provider) {
        return Collections.singletonList(this.block);
    }

    @Override
    public int requestAmount(ConditionContainerProvider provider) {
        return 1;
    }

    @Override
    public boolean isValid() {
        return this.block != null;
    }
}

