/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.conditiondata;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.protection.PlayerID;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Provider;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionDataContainer;
import com.valkyrieofnight.vlib.registry.conditiondata.base.ConditionScope;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ConditionDataContainerHandler {
    public static final String DATA_NAME = "valkyrielib_conditiondata";
    private static ConditionDataContainerHandler INST;
    protected static final boolean DELETE_UNSPECIFIED = true;
    protected ConditionDataContainer allTemplate;
    protected ConditionDataContainer globalDatabaseTemplate;
    protected ConditionDataContainer dimensionDatabaseTemplate;
    protected ConditionDataContainer playerDatabaseTemplate;
    protected ConditionDataContainer globalDatabase;
    protected ConcurrentMap<DimensionType, ConditionDataContainer> dimensionDatabases = Maps.newConcurrentMap();
    protected ConcurrentMap<PlayerID, ConditionDataContainer> playerDatabases = Maps.newConcurrentMap();
    protected ConditionWorldSaveData saveData;

    public static ConditionDataContainerHandler getInstance() {
        if (INST == null) {
            INST = new ConditionDataContainerHandler();
        }
        return INST;
    }

    private ConditionDataContainerHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (!e.getWorld().func_201670_d()) {
            this.saveData = this.loadConditionDataStorage((ServerWorld)e.getWorld());
        }
    }

    public void reloadData(ConditionDataContainer allTemplate) {
        this.allTemplate = allTemplate;
        this.globalDatabaseTemplate = allTemplate.copyScoped(ConditionScope.GLOBAL);
        this.dimensionDatabaseTemplate = allTemplate.copyScoped(ConditionScope.DIMENSION);
        this.playerDatabaseTemplate = allTemplate.copyScoped(ConditionScope.PLAYER);
        if (this.globalDatabase == null) {
            this.globalDatabase = this.globalDatabaseTemplate.copy();
        } else {
            this.globalDatabase.reloadFromTemplate(this.globalDatabaseTemplate, true);
        }
        for (ConditionDataContainer cdc : this.dimensionDatabases.values()) {
            cdc.reloadFromTemplate(this.dimensionDatabaseTemplate, true);
        }
        for (ConditionDataContainer cdc : this.playerDatabases.values()) {
            cdc.reloadFromTemplate(this.playerDatabaseTemplate, true);
        }
        if (this.saveData != null) {
            this.saveData.loadIntoHandler(this);
        }
    }

    private ConditionWorldSaveData loadConditionDataStorage(ServerWorld world) {
        return (ConditionWorldSaveData)world.func_217481_x().func_215753_b(ConditionWorldSaveData::new, DATA_NAME);
    }

    public ConditionDataContainer getGlobalDatabase() {
        return this.globalDatabase;
    }

    public ConditionDataContainer getDimensionDatabase(DimensionType dimensionType) {
        if (dimensionType == null) {
            return null;
        }
        if (!this.dimensionDatabases.containsKey(dimensionType)) {
            this.dimensionDatabases.put(dimensionType, this.dimensionDatabaseTemplate.copy());
        }
        return (ConditionDataContainer)this.dimensionDatabases.get(dimensionType);
    }

    public ConditionDataContainer getPlayerDatabase(PlayerID player) {
        if (player == null) {
            return null;
        }
        if (!this.playerDatabases.containsKey(player)) {
            this.playerDatabases.put(player, this.playerDatabaseTemplate.copy());
        }
        return (ConditionDataContainer)this.playerDatabases.get(player);
    }

    public ConditionContainerProvider getProvider(Provider<DimensionType> dim, Provider<PlayerID> player) {
        return new ConditionContainerProvider(this.getGlobalDatabase(), dim, player);
    }

    protected CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("global", (INBT)this.globalDatabase.serializeNBT());
        CompoundNBT dims = new CompoundNBT();
        for (DimensionType dt : this.dimensionDatabases.keySet()) {
            ConditionDataContainer cdc = (ConditionDataContainer)this.dimensionDatabases.get(dt);
            dims.func_218657_a(VLID.from(dt).toString(), (INBT)cdc.serializeNBT());
        }
        nbt.func_218657_a("dims", (INBT)dims);
        CompoundNBT players = new CompoundNBT();
        for (PlayerID player : this.playerDatabases.keySet()) {
            ConditionDataContainer playerData = (ConditionDataContainer)this.playerDatabases.get(player);
            if (player == null || playerData == null) continue;
            players.func_218657_a(player.toUUID().toString(), (INBT)playerData.serializeNBT());
        }
        nbt.func_218657_a("players", (INBT)players);
        return nbt;
    }

    protected void deserializeNBT(CompoundNBT nbt) {
        if (nbt == null) {
            return;
        }
        if (nbt.func_74764_b("global")) {
            this.globalDatabase.deserializeNBT(nbt.func_74775_l("global"));
        }
        if (nbt.func_74764_b("dims")) {
            CompoundNBT dims = nbt.func_74775_l("dims");
            for (DimensionType dt : this.dimensionDatabases.keySet()) {
                String dim = VLID.from(dt).toString();
                if (!dims.func_74764_b(dim)) continue;
                ConditionDataContainer cdc = (ConditionDataContainer)this.dimensionDatabases.get(dt);
                cdc.deserializeNBT(dims.func_74775_l(dim));
            }
        }
        if (nbt.func_74764_b("players")) {
            CompoundNBT players = nbt.func_74775_l("players");
            for (PlayerID player : this.playerDatabases.keySet()) {
                String uuid = player.toUUID().toString();
                ConditionDataContainer playerData = (ConditionDataContainer)this.playerDatabases.get(player);
                if (playerData == null || !players.func_74764_b(uuid)) continue;
                playerData.deserializeNBT(players.func_74775_l(uuid));
            }
        }
    }

    protected static class ConditionWorldSaveData
    extends WorldSavedData {
        protected CompoundNBT data;

        public ConditionWorldSaveData() {
            super(ConditionDataContainerHandler.DATA_NAME);
        }

        protected void loadIntoHandler(ConditionDataContainerHandler handler) {
            handler.deserializeNBT(this.data);
        }

        protected void saveFromHandler(ConditionDataContainerHandler handler) {
            this.data = handler.serializeNBT();
            this.func_76185_a();
        }

        public void func_76184_a(CompoundNBT nbt) {
            this.data = nbt;
        }

        public CompoundNBT func_189551_b(CompoundNBT compound) {
            return ConditionDataContainerHandler.getInstance().serializeNBT();
        }

        public void saveAndSetChanged() {
        }
    }
}

