/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.conditiondata;

import com.valkyrieofnight.vlib.core.protection.PlayerID;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Function1a;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Provider;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionDataContainer;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionDataContainerHandler;
import com.valkyrieofnight.vlib.registry.conditiondata.base.ConditionScope;
import net.minecraft.world.DimensionType;

public class ConditionContainerProvider {
    private final ConditionDataContainer global;
    private final Function1a<DimensionType, ConditionDataContainer> dimensionRetriever;
    private final Function1a<PlayerID, ConditionDataContainer> playerRetriever;
    private final Provider<DimensionType> dimensionTypeProvider;
    private final Provider<PlayerID> playerIDProvider;

    public ConditionContainerProvider(ConditionDataContainer global, Provider<DimensionType> dimensionTypeProvider, Provider<PlayerID> playerIDProvider) {
        this.global = global;
        this.dimensionTypeProvider = dimensionTypeProvider;
        this.playerIDProvider = playerIDProvider;
        this.dimensionRetriever = ConditionDataContainerHandler.getInstance()::getDimensionDatabase;
        this.playerRetriever = ConditionDataContainerHandler.getInstance()::getPlayerDatabase;
    }

    public ConditionDataContainer get(ConditionScope container) {
        switch (container) {
            case GLOBAL: {
                return this.global;
            }
            case PLAYER: {
                return this.playerRetriever.execute(this.playerIDProvider.request());
            }
            case DIMENSION: {
                return this.dimensionRetriever.execute(this.dimensionTypeProvider.request());
            }
        }
        return this.global;
    }
}

