/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action1a;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.recipe.network.RecipePacket;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.network.PacketBuffer;

public class RecipeRegistryManager {
    private static volatile RecipeRegistryManager INST;
    protected volatile ConcurrentMap<VLID, Action1a<PacketBuffer>> map = Maps.newConcurrentMap();

    public static RecipeRegistryManager getInstance() {
        if (INST == null) {
            INST = new RecipeRegistryManager();
        }
        return INST;
    }

    private RecipeRegistryManager() {
    }

    public void register(VLID id, Action1a<PacketBuffer> packetReader) {
        if (packetReader == null) {
            return;
        }
        if (this.map.containsKey(id)) {
            return;
        }
        this.map.put(id, packetReader);
    }

    public void handlePacket(RecipePacket packet) {
        Action1a act;
        if (packet != null && this.map.containsKey(packet.getRegistryID()) && packet.getPacketBuffer() != null && (act = (Action1a)this.map.get(packet.getRegistryID())) != null) {
            act.execute(packet.getPacketBuffer());
        }
    }
}

