/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.obj.tile.impl;

import com.valkyrieofnight.vlib.core.obj.tileentity.VLModularTile;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.IReceivePacketFromClient;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.network.BaseTilePacket;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.Module;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.ModuleBuilders;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.SidedTickerModule;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.base.IModuleBuilder;
import com.valkyrieofnight.vlib.core.util.StyleUtil;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import com.valkyrieofnight.vlib.core.util.math.XYZOrientation;
import com.valkyrieofnight.vlib.core.util.player.PlayerUtil;
import com.valkyrieofnight.vlib.modifier.TileModifierHandler;
import com.valkyrieofnight.vlib.multiblock.MMultiblock;
import com.valkyrieofnight.vlib.multiblock.autoutil.AbstractAuto;
import com.valkyrieofnight.vlib.multiblock.autoutil.AutoBuilder;
import com.valkyrieofnight.vlib.multiblock.autoutil.AutoDestructor;
import com.valkyrieofnight.vlib.multiblock.autoutil.AutoMode;
import com.valkyrieofnight.vlib.multiblock.autoutil.AutoPreview;
import com.valkyrieofnight.vlib.multiblock.constructor.ContinuousConstructor;
import com.valkyrieofnight.vlib.multiblock.obj.tile.IController;
import com.valkyrieofnight.vlib.multiblock.obj.tile.ISlave;
import com.valkyrieofnight.vlib.multiblock.ui.ControllerAutoPacket;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionDataContainerHandler;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public abstract class ControllerTile
extends VLModularTile
implements ITickableTileEntity,
IController,
IReceivePacketFromClient {
    protected volatile Module ccuModule;
    protected volatile ConditionContainerProvider conditionContainerProvider;
    protected volatile ContinuousConstructor scanner;
    protected volatile TileModifierHandler modifierHandler;
    protected volatile Direction direction = Direction.NORTH;
    private volatile AbstractAuto auto = null;
    private AutoMode autoMode = AutoMode.STOP;
    private UUID autoPlayer = null;
    private XYZOrientation autoOrientation = null;

    public ControllerTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.scanner = new ContinuousConstructor(this, this::queueValidOrientations);
        this.conditionContainerProvider = ConditionDataContainerHandler.getInstance().getProvider(() -> this.func_145831_w().func_230315_m_(), this::getPlacedBy);
        this.modifierHandler = new TileModifierHandler(this);
        this.scanner.setOnMultiblockFormed(this::internalOnMultiblockFormed);
        this.scanner.setOnMultiblockDeform(this::internalMultiblockDeform);
        this.scanner.setOnMultiblockDeformationComplete(this::internalMultiblockDeformationComplete);
    }

    protected void setupMainModule() {
        this.setupMainModule(ModuleBuilders.module());
    }

    @Override
    protected final void setupMainModule(Module.AbstractBuilder builder) {
        Object b = builder.addModule(((SidedTickerModule.Builder)((SidedTickerModule.Builder)((SidedTickerModule.Builder)ModuleBuilders.sidedTicker().serverTick(() -> {
            if (this.autoMode != AutoMode.STOP) {
                if (this.auto == null) {
                    PlayerEntity player = PlayerUtil.getPlayerFromWorld(this.func_145831_w(), this.autoPlayer);
                    if (player != null) {
                        if (this.autoMode == AutoMode.PREVIEW) {
                            this.preview(player, MathUtil.clamp(this.getStructureID(), 1, 8), false);
                        } else if (this.autoMode.canBuild() && !this.scanner.isFormed()) {
                            this.construct(player, MathUtil.clamp(this.getStructureID(), 1, 8), this.autoMode.canBreak());
                        } else if (this.autoMode.canBreak()) {
                            this.destruct(player, MathUtil.clamp(this.getStructureID(), 1, 8), false);
                        }
                    } else {
                        this.auto = null;
                        this.autoMode = AutoMode.STOP;
                        this.autoPlayer = null;
                    }
                } else if (this.auto != null) {
                    if (this.auto.isRunning()) {
                        this.auto.tick();
                    } else {
                        this.autoMode = AutoMode.STOP;
                        this.autoPlayer = null;
                        this.auto = null;
                    }
                }
                return;
            }
            this.scanner.tick();
            if (this.scanner.isFormed()) {
                this.modifierHandler.scanAttributes();
                this.serverTickFormed();
            } else {
                this.serverTickUnformed();
            }
            this.serverTick();
        })).commonTick(this::commonTick)).clientTick(this::clientTick)).addModule((IModuleBuilder)builder));
        super.setupMainModule((Module.AbstractBuilder)b);
    }

    protected void setupCCUModule(Module.AbstractBuilder builder) {
        if (builder != null) {
            this.ccuModule = builder.build();
        }
    }

    public void queueValidOrientations(Queue<XYZOrientation> orientationQueue) {
        orientationQueue.addAll(this.getValid());
    }

    protected void setDirection(Direction dir) {
        this.direction = dir;
    }

    @Override
    public void receiveData(BaseTilePacket packet) {
        if (packet instanceof ControllerAutoPacket) {
            ControllerAutoPacket cap = (ControllerAutoPacket)packet;
            this.autoMode = cap.getMode();
            this.autoPlayer = cap.getPlayerID();
            this.autoOrientation = cap.getOrientation();
        }
    }

    public void construct(PlayerEntity player, int speed, boolean breakFirst) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.func_145831_w().func_201670_d()) {
            return;
        }
        this.construct(player, speed, false, breakFirst, false);
    }

    protected void construct(PlayerEntity p, int speed, boolean override, boolean breakFirst, boolean breakOtherTiles) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (breakFirst) {
            p.func_146105_b((ITextComponent)new TranslationTextComponent("status.valkyrielib.starting_destructor").func_230530_a_(StyleUtil.create(Color4.RED)), false);
            this.auto = new AutoDestructor<ControllerTile>((ServerWorld)this.func_145831_w(), this, p, this.autoOrientation, speed, breakOtherTiles, () -> {
                this.construct(p, speed, true, false, breakOtherTiles);
                this.func_70296_d();
            });
        } else {
            p.func_146105_b((ITextComponent)new TranslationTextComponent("status.valkyrielib.starting_constructor").func_230530_a_(StyleUtil.create(Color4.DARK_GREEN)), false);
            if (override || this.auto == null && !this.isFormed()) {
                this.auto = new AutoBuilder<ControllerTile>((ServerWorld)this.func_145831_w(), this, p, this.autoOrientation, speed, false, this::func_70296_d);
            }
        }
        this.func_70296_d();
    }

    public void destruct(PlayerEntity player, int speed, boolean breakOtherTiles) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.func_145831_w().func_201670_d()) {
            return;
        }
        if (this.auto == null) {
            this.auto = new AutoDestructor<ControllerTile>((ServerWorld)this.func_145831_w(), this, player, this.autoOrientation, speed, breakOtherTiles, this::func_70296_d);
        }
    }

    public void preview(PlayerEntity player, int speed, boolean breakOtherTiles) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.func_145831_w().func_201670_d()) {
            return;
        }
        if (this.auto == null) {
            this.auto = new AutoPreview<ControllerTile>((ServerWorld)this.func_145831_w(), this, player, this.autoOrientation, speed, breakOtherTiles, this::func_70296_d);
        }
    }

    private final void internalOnMultiblockFormed() {
        this.modifierHandler.setScannable(this.scanner.getAllOfType(MMultiblock.MODIFIER_COMPONENT));
        this.onMultiblockFormed();
        this.func_70296_d();
    }

    protected void onMultiblockFormed() {
    }

    private final void internalMultiblockDeform() {
        this.onMultiblockDeform();
        this.func_70296_d();
    }

    private final void internalMultiblockDeformationComplete() {
        this.onMultiblockDeformationComplete();
        this.func_70296_d();
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    protected void onMultiblockDeform() {
    }

    protected void onMultiblockDeformationComplete() {
    }

    @Override
    public XYZOrientation getOrientation() {
        return this.scanner.getOrientation();
    }

    @Override
    public void onSlaveBroken(ISlave slave) {
    }

    @Override
    public boolean isSlave(BlockPos pos) {
        return this.scanner.isSlave(pos);
    }

    @Override
    public boolean isFormed() {
        return this.scanner.isFormed();
    }

    @Deprecated
    protected void clientTick() {
    }

    @Deprecated
    protected void serverTick() {
    }

    protected void serverTickFormed() {
        this.ccuModule.tick(this);
    }

    protected void serverTickUnformed() {
    }

    @Deprecated
    protected void commonTick() {
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        super.save(nbt, type);
        this.ccuModule.save(nbt, type);
        if (type == SaveDataType.TILE || type == SaveDataType.TO_CLIENT) {
            CompoundNBT scanner = new CompoundNBT();
            this.scanner.save(scanner, type);
            nbt.func_218657_a("scanner", (INBT)scanner);
        }
        if (type == SaveDataType.TO_CLIENT) {
            nbt.func_218657_a("modifier", (INBT)this.modifierHandler.serializeNBT());
        }
        if (this.direction != null) {
            nbt.func_74768_a("direction", this.direction.ordinal());
        }
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt, SaveDataType type) {
        super.load(nbt, type);
        this.ccuModule.load(nbt, type);
        if ((type == SaveDataType.TILE || type == SaveDataType.FROM_SERVER) && nbt.func_74764_b("scanner")) {
            this.scanner.load(nbt.func_74775_l("scanner"), type);
        }
        if (type == SaveDataType.FROM_SERVER && nbt.func_74764_b("modifier")) {
            this.modifierHandler.deserializeNBT(nbt.func_74775_l("modifier"));
        }
        if (nbt.func_74764_b("direction")) {
            this.direction = Direction.func_82600_a((int)nbt.func_74762_e("direction"));
        }
    }
}

