/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.component;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.util.math.BlockOffset;
import com.valkyrieofnight.vlib.core.util.math.XYZOrientation;
import com.valkyrieofnight.vlib.multiblock.component.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;

public class ComponentLayoutList {
    private final Component component;
    private volatile CopyOnWriteArrayList<BlockOffset> positions = Lists.newCopyOnWriteArrayList();

    public ComponentLayoutList(Component component) {
        this.component = component;
    }

    public ComponentLayoutList add(BlockOffset offset) {
        if (offset != null) {
            this.positions.add(offset);
        }
        return this;
    }

    public ComponentLayoutList remove(BlockOffset offset) {
        this.positions.remove(offset);
        return this;
    }

    public boolean contains(BlockOffset offset) {
        return this.positions.contains(offset);
    }

    public int getCount() {
        return this.positions.size();
    }

    public Component getComponent() {
        return this.component;
    }

    public void forEach(Consumer<BlockOffset> action) {
        this.positions.forEach(action);
    }

    public Collection<BlockOffset> getAll() {
        return this.positions;
    }

    public Collection<BlockPos> getAllRotated(BlockPos controllerPosition, XYZOrientation direction) {
        ArrayList r = Lists.newArrayList();
        for (BlockOffset bo : this.positions) {
            r.add(bo.getRotatedPosition(direction, controllerPosition));
        }
        return r;
    }
}

