/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.util.StyleUtil;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.math.BlockOffset;
import com.valkyrieofnight.vlib.core.util.math.XYZOrientation;
import com.valkyrieofnight.vlib.multiblock.component.Component;
import com.valkyrieofnight.vlib.multiblock.component.ComponentLayoutList;
import com.valkyrieofnight.vlib.multiblock.component.ComponentRegistry;
import com.valkyrieofnight.vlib.multiblock.component.ComponentSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public final class Structure {
    private volatile CopyOnWriteArrayList<Component> sortedOrder = Lists.newCopyOnWriteArrayList();
    private volatile ConcurrentMap<Component, ComponentLayoutList> layoutListMap = Maps.newConcurrentMap();
    private volatile ConcurrentMap<Component, ComponentSettings> settingsMap = Maps.newConcurrentMap();
    private volatile ConcurrentMap<BlockOffset, Component> componentMap = Maps.newConcurrentMap();
    private volatile CopyOnWriteArrayList<XYZOrientation> validOrientations = Lists.newCopyOnWriteArrayList();
    private volatile ConcurrentMap<Component, BlockState> creativeStates = Maps.newConcurrentMap();
    private boolean forwardSymmetrical;

    private Structure() {
    }

    public Set<Component> getComponents() {
        return this.layoutListMap.keySet();
    }

    public ComponentLayoutList getLayoutList(Component comp) {
        if (comp == null) {
            return null;
        }
        return (ComponentLayoutList)this.layoutListMap.get(comp);
    }

    public ComponentLayoutList getLayoutList(BlockOffset offset) {
        if (offset == null) {
            return null;
        }
        for (ComponentLayoutList list : this.layoutListMap.values()) {
            if (!list.contains(offset)) continue;
            return list;
        }
        return null;
    }

    public ComponentSettings getComponentSettings(Component comp) {
        if (comp == null) {
            return null;
        }
        return (ComponentSettings)this.settingsMap.get(comp);
    }

    public Component getComponent(BlockOffset offset) {
        if (offset == null) {
            return null;
        }
        return (Component)this.componentMap.get(offset);
    }

    public Component getComponent(BlockPos controller, BlockPos slave) {
        if (controller == null || slave == null) {
            return null;
        }
        return this.getComponent(BlockOffset.getOffset(controller, slave));
    }

    public XYZOrientation getNextOrientation(XYZOrientation current) {
        int i = this.validOrientations.indexOf((Object)current) + 1;
        if (i >= this.validOrientations.size()) {
            return this.validOrientations.get(0);
        }
        return this.validOrientations.get(i);
    }

    public List<XYZOrientation> getValidOrientations() {
        return this.validOrientations;
    }

    public boolean isValidOrientation(@NotNull XYZOrientation orientation) {
        return this.validOrientations.contains((Object)orientation);
    }

    public boolean isOffsetOccupied(BlockOffset offset) {
        return this.componentMap.containsKey(offset);
    }

    public boolean isForwardSymmetrical() {
        return this.forwardSymmetrical;
    }

    public Map<BlockOffset, Boolean> getBlankClaimedStateMap() {
        LinkedHashMap r = Maps.newLinkedHashMap();
        for (ComponentLayoutList list : this.layoutListMap.values()) {
            for (BlockOffset o : list.getAll()) {
                r.put(o, false);
            }
        }
        return r;
    }

    public boolean contains(BlockOffset off) {
        if (off == null) {
            return false;
        }
        return this.componentMap.containsKey(off);
    }

    public void place(World world, PlayerEntity player, BlockPos controller, XYZOrientation orientation, int lastPlaced) {
    }

    public int calculateTotalStacks() {
        int stacks = 0;
        for (ComponentLayoutList l : this.layoutListMap.values()) {
            int listStacks = l.getCount() / 64;
            stacks += listStacks;
        }
        return stacks;
    }

    public int getTotalBlocks() {
        int total = 0;
        for (ComponentLayoutList l : this.layoutListMap.values()) {
            total += l.getCount();
        }
        return total;
    }

    public List<Component> getOrder() {
        return this.sortedOrder;
    }

    public List<IFormattableTextComponent> getRequirements() {
        Style countColor = StyleUtil.create(Color4.CYAN);
        Style xColor = StyleUtil.create(Color4.SILVER);
        Style componentColor = StyleUtil.create(Color4.VIOLET);
        ArrayList list = Lists.newArrayList();
        for (Component c : this.sortedOrder) {
            ComponentLayoutList ll = (ComponentLayoutList)this.layoutListMap.get(c);
            StringTextComponent req = new StringTextComponent("");
            req.func_230529_a_((ITextComponent)new StringTextComponent("" + ll.getCount()).func_230530_a_(countColor));
            req.func_230529_a_((ITextComponent)new StringTextComponent("x").func_230530_a_(xColor));
            req.func_230529_a_((ITextComponent)new TranslationTextComponent(c.getUnlocalizedTypes()).func_230530_a_(componentColor));
            list.add(req);
        }
        return list;
    }

    public static class Builder {
        private volatile CopyOnWriteArrayList<Component> sortedOrder = Lists.newCopyOnWriteArrayList();
        private ConcurrentMap<Component, ComponentLayoutList> layoutListMap = Maps.newConcurrentMap();
        private ConcurrentMap<Component, ComponentSettings> settingsMap = Maps.newConcurrentMap();
        private CopyOnWriteArrayList<XYZOrientation> validOrientations = Lists.newCopyOnWriteArrayList();
        private ConcurrentMap<Component, BlockState> creativeStates = Maps.newConcurrentMap();
        private boolean forwardSymmetrical = false;

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        private boolean isOffsetOccupied(BlockOffset offset) {
            for (ComponentLayoutList list : this.layoutListMap.values()) {
                if (!list.contains(offset)) continue;
                return true;
            }
            return false;
        }

        private void createBase(Component comp) {
            this.layoutListMap.put(comp, new ComponentLayoutList(comp));
            this.settingsMap.put(comp, new ComponentSettings());
        }

        public Builder setForwardSymmetrical() {
            this.forwardSymmetrical = true;
            return this;
        }

        public Builder addCreativeState(Component comp, BlockState state) {
            if (state != null && comp != null) {
                this.creativeStates.put(comp, state);
            }
            return this;
        }

        public Builder copy(Structure structure, Component component) {
            ComponentLayoutList cll = structure.getLayoutList(component);
            for (BlockOffset bo : cll.getAll()) {
                this.addComponent(component, bo);
            }
            return this;
        }

        public Builder copy(Structure structure) {
            for (Component comp : structure.getComponents()) {
                this.copy(structure, comp);
            }
            return this;
        }

        public Builder addValidOrientation(XYZOrientation direction) {
            if (direction == null || this.validOrientations.contains((Object)direction)) {
                return this;
            }
            this.validOrientations.add(direction);
            return this;
        }

        public Builder addValidOrientation(XYZOrientation ... orientations) {
            for (XYZOrientation o : orientations) {
                this.addValidOrientation(o);
            }
            return this;
        }

        public Builder addComponent(Component comp, BlockOffset offset) {
            if (comp == null) {
                throw new NullPointerException("Component provided was null");
            }
            if (offset == null) {
                throw new NullPointerException("BlockOffset provided was null");
            }
            if (!ComponentRegistry.getInstance().isRegistered(comp.getID())) {
                throw new RuntimeException("Component with id: " + comp.getID() + " is not registered. Please register in order to use it inside of a Structure.");
            }
            if (this.isOffsetOccupied(offset)) {
                throw new RuntimeException("BlockOffset at: " + offset + " is already occupied with another component.");
            }
            if (!this.layoutListMap.containsKey(comp)) {
                this.createBase(comp);
            }
            ComponentLayoutList list = (ComponentLayoutList)this.layoutListMap.get(comp);
            list.add(offset);
            return this;
        }

        public Builder addComponent(Component comp, int xOffset, int yOffset, int zOffset) {
            this.addComponent(comp, new BlockOffset(xOffset, yOffset, zOffset));
            return this;
        }

        public Builder addComponentParallelX(Component comp, int xOffset, int yOffset, int zOffset) {
            if (xOffset == 0) {
                this.addComponent(comp, xOffset, yOffset, zOffset);
            } else {
                this.addComponent(comp, xOffset, yOffset, zOffset);
                this.addComponent(comp, -xOffset, yOffset, zOffset);
            }
            return this;
        }

        public Builder addComponentParallelY(Component comp, int xOffset, int yOffset, int zOffset) {
            if (yOffset == 0) {
                this.addComponent(comp, xOffset, yOffset, zOffset);
            } else {
                this.addComponent(comp, xOffset, yOffset, zOffset);
                this.addComponent(comp, xOffset, -yOffset, zOffset);
            }
            return this;
        }

        public Builder addComponentParallelZ(Component comp, int xOffset, int yOffset, int zOffset) {
            if (xOffset == 0) {
                this.addComponent(comp, xOffset, yOffset, zOffset);
            } else {
                this.addComponent(comp, xOffset, yOffset, zOffset);
                this.addComponent(comp, xOffset, yOffset, -zOffset);
            }
            return this;
        }

        public Builder addComponentSymmetricalXZ(Component comp, int xOffset, int yOffset, int zOffset) {
            if (xOffset == 0 && zOffset == 0) {
                if (yOffset == 0) {
                    return this;
                }
                this.addComponent(comp, xOffset, yOffset, zOffset);
            } else if (Math.abs(xOffset) == Math.abs(zOffset)) {
                this.addComponent(comp, xOffset, yOffset, zOffset);
                this.addComponent(comp, -xOffset, yOffset, zOffset);
                this.addComponent(comp, xOffset, yOffset, -zOffset);
                this.addComponent(comp, -xOffset, yOffset, -zOffset);
            } else if (xOffset == 0 || zOffset == 0) {
                int off = Math.max(xOffset, zOffset);
                this.addComponent(comp, off, yOffset, 0);
                this.addComponent(comp, -off, yOffset, 0);
                this.addComponent(comp, 0, yOffset, off);
                this.addComponent(comp, 0, yOffset, -off);
            } else {
                this.addComponent(comp, xOffset, yOffset, zOffset);
                this.addComponent(comp, -xOffset, yOffset, zOffset);
                this.addComponent(comp, xOffset, yOffset, -zOffset);
                this.addComponent(comp, -xOffset, yOffset, -zOffset);
                this.addComponent(comp, zOffset, yOffset, xOffset);
                this.addComponent(comp, -zOffset, yOffset, xOffset);
                this.addComponent(comp, zOffset, yOffset, -xOffset);
                this.addComponent(comp, -zOffset, yOffset, -xOffset);
            }
            return this;
        }

        public Builder addComponentSymmetricalXY(Component comp, int xOffset, int yOffset, int zOffset) {
            if (xOffset == 0 && yOffset == 0) {
                if (zOffset == 0) {
                    return this;
                }
                this.addComponent(comp, xOffset, yOffset, zOffset);
            } else if (Math.abs(xOffset) == Math.abs(yOffset)) {
                this.addComponent(comp, xOffset, yOffset, zOffset);
                this.addComponent(comp, -xOffset, yOffset, zOffset);
                this.addComponent(comp, xOffset, -yOffset, zOffset);
                this.addComponent(comp, -xOffset, -yOffset, zOffset);
            } else if (xOffset == 0 || yOffset == 0) {
                int off = Math.max(xOffset, yOffset);
                this.addComponent(comp, off, 0, zOffset);
                this.addComponent(comp, -off, 0, zOffset);
                this.addComponent(comp, 0, off, zOffset);
                this.addComponent(comp, 0, -off, zOffset);
            } else {
                this.addComponent(comp, xOffset, yOffset, zOffset);
                this.addComponent(comp, -xOffset, yOffset, zOffset);
                this.addComponent(comp, xOffset, -yOffset, zOffset);
                this.addComponent(comp, -xOffset, -yOffset, zOffset);
                this.addComponent(comp, yOffset, xOffset, zOffset);
                this.addComponent(comp, -yOffset, xOffset, zOffset);
                this.addComponent(comp, yOffset, -xOffset, zOffset);
                this.addComponent(comp, -yOffset, -xOffset, zOffset);
            }
            return this;
        }

        public Builder addComponentSymmetricalZY(Component comp, int xOffset, int yOffset, int zOffset) {
            if (zOffset == 0 && yOffset == 0) {
                if (xOffset == 0) {
                    return this;
                }
                this.addComponent(comp, xOffset, yOffset, zOffset);
            } else if (Math.abs(zOffset) == Math.abs(yOffset)) {
                this.addComponent(comp, xOffset, yOffset, zOffset);
                this.addComponent(comp, xOffset, yOffset, -zOffset);
                this.addComponent(comp, xOffset, -yOffset, zOffset);
                this.addComponent(comp, xOffset, -yOffset, -zOffset);
            } else if (zOffset == 0 || yOffset == 0) {
                int off = Math.max(zOffset, yOffset);
                this.addComponent(comp, xOffset, off, 0);
                this.addComponent(comp, xOffset, -off, 0);
                this.addComponent(comp, xOffset, 0, off);
                this.addComponent(comp, xOffset, 0, -off);
            } else {
                this.addComponent(comp, xOffset, yOffset, zOffset);
                this.addComponent(comp, xOffset, yOffset, -zOffset);
                this.addComponent(comp, xOffset, -yOffset, zOffset);
                this.addComponent(comp, xOffset, -yOffset, -zOffset);
                this.addComponent(comp, xOffset, zOffset, yOffset);
                this.addComponent(comp, xOffset, zOffset, -yOffset);
                this.addComponent(comp, xOffset, -zOffset, yOffset);
                this.addComponent(comp, xOffset, -zOffset, -yOffset);
            }
            return this;
        }

        @Deprecated
        public Builder addComponentSymmetricalXYZ(Component comp, int xOffset, int yOffset, int zOffset) {
            return this;
        }

        public Structure build() {
            this.layoutListMap.keySet().forEach(k -> this.sortedOrder.add((Component)k));
            Collections.sort(this.sortedOrder);
            Structure s = new Structure();
            s.sortedOrder = this.sortedOrder;
            for (Component component : this.sortedOrder) {
                ComponentLayoutList cll = (ComponentLayoutList)this.layoutListMap.get(component);
                ComponentSettings cs = (ComponentSettings)this.settingsMap.get(component);
                s.settingsMap.put(component, cs);
                s.layoutListMap.put(component, cll);
            }
            s.validOrientations.addAll(this.validOrientations);
            if (s.validOrientations.isEmpty()) {
                XYZOrientation[] all;
                for (XYZOrientation o : all = XYZOrientation.getAll()) {
                    s.validOrientations.add(o);
                }
            }
            s.creativeStates = this.creativeStates;
            s.componentMap = Maps.newConcurrentMap();
            for (ComponentLayoutList componentLayoutList : s.layoutListMap.values()) {
                for (BlockOffset o : componentLayoutList.getAll()) {
                    s.componentMap.put(o, componentLayoutList.getComponent());
                }
            }
            s.forwardSymmetrical = this.forwardSymmetrical;
            return s;
        }
    }
}

