/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.module.base;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.ui.theme.client.ThemeRegistryClient;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeRegistry;
import com.valkyrieofnight.vlib.core.ui.theme.server.ThemeRegistryServer;
import com.valkyrieofnight.vlib.modloader.util.SideUtil;
import com.valkyrieofnight.vlib.module.base.VLModule;
import com.valkyrieofnight.vlib.module.config.IConfig;
import com.valkyrieofnight.vlib.module.core.VLMainModule;
import com.valkyrieofnight.vlib.module.interfaces.IFinalInitializer;
import com.valkyrieofnight.vlib.module.interfaces.IInit;
import com.valkyrieofnight.vlib.module.interfaces.IInitClient;
import com.valkyrieofnight.vlib.module.interfaces.IInitServer;
import com.valkyrieofnight.vlib.module.proxy.ProxyClient;
import com.valkyrieofnight.vlib.module.proxy.ProxyCommon;
import com.valkyrieofnight.vlib.module.proxy.ProxyServer;
import java.util.Iterator;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class VLMod {
    private static volatile Map<String, VLMod> MODS = Maps.newConcurrentMap();
    private static volatile boolean FINAL_INIT_COMPLETE = false;
    private final String modid;
    private volatile VLMainModule mainModule;
    private volatile ProxyCommon proxy;
    private volatile String configBaseDirectory;
    private volatile boolean initialized = false;
    private static int createOrder = 0;
    private static int initOrder = 0;

    private static void registerMod(String modid, VLMod mod) {
        MODS.put(modid, mod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean haveAllModsInitialized() {
        Iterator<VLMod> iterator = MODS.values().iterator();
        while (iterator.hasNext()) {
            VLMod mod;
            VLMod vLMod = mod = iterator.next();
            synchronized (vLMod) {
                if (!mod.hasInitialzed()) {
                    return false;
                }
            }
        }
        return true;
    }

    private static void attemptFinalInitialization() {
        if (VLMod.haveAllModsInitialized() && !FINAL_INIT_COMPLETE) {
            FINAL_INIT_COMPLETE = true;
            for (VLMod vm : MODS.values()) {
                vm.mainModule._finalInit();
            }
            if (SideUtil.isClient()) {
                // empty if block
            }
        }
    }

    public VLMod(String modid) {
        this.modid = modid;
        this.mainModule = new VLMainModule(this, modid){

            @Override
            public void init(IConfig config) {
                VLMod.this._init(config);
            }

            @Override
            public void initServer(IConfig config) {
                VLMod.this._initServer(config);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void initClient(IConfig config) {
                VLMod.this._initClient(config);
            }

            @Override
            public void setupModule() {
                VLMod.this.setupMod();
            }

            @Override
            public void finalInit(IConfig cfg) {
                VLMod.this._finalInitailization(cfg);
            }
        };
        this.configBaseDirectory = "config/";
        this.setup2();
    }

    public VLMod(String suite, String member) {
        this.modid = suite + member;
        this.setup1(suite, member);
        this.setup2();
    }

    public VLMod(String suite, String member, String modid) {
        this.modid = modid;
        this.setup1(suite, member);
        this.setup2();
    }

    private void setup1(String suite, String member) {
        this.mainModule = new VLMainModule(this, member){

            @Override
            public void init(IConfig config) {
                VLMod.this._init(config);
            }

            @Override
            public void initServer(IConfig config) {
                VLMod.this._initServer(config);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void initClient(IConfig config) {
                VLMod.this._initClient(config);
            }

            @Override
            public void setupModule() {
                VLMod.this.setupMod();
            }

            @Override
            public void finalInit(IConfig cfg) {
                VLMod.this._finalInitailization(cfg);
            }
        };
        this.configBaseDirectory = "config/" + suite + "/";
    }

    private void setup2() {
        VLMod.registerMod(this.modid, this);
        this.proxy = SideUtil.isClient() ? new ProxyClient(this, ThemeRegistryClient.getInstance()) : new ProxyServer(this, ThemeRegistryServer.getInstance());
        this.mainModule._0moduleSetup();
        this.mainModule._1moduleConfigurationSetup(this.configBaseDirectory);
        this.proxy.registerAssets();
    }

    public abstract void setupMod();

    public final void initMod() {
        this.mainModule._3init();
        this.proxy.init();
        this.mainModule._4saveConfigs();
        this.initialized = true;
        VLMod.attemptFinalInitialization();
    }

    public boolean hasInitialzed() {
        return this.initialized;
    }

    public void addChild(VLModule module) {
        if (module != null) {
            this.mainModule.addChild(module);
        }
    }

    private void _init(IConfig config) {
        if (this instanceof IInit) {
            ((IInit)((Object)this)).init(config);
        }
    }

    private void _initServer(IConfig config) {
        if (this instanceof IInitServer) {
            ((IInitServer)((Object)this)).initServer(config);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void _initClient(IConfig config) {
        if (this instanceof IInitClient) {
            ((IInitClient)((Object)this)).initClient(config);
        }
    }

    private void _finalInitailization(IConfig config) {
        if (this instanceof IFinalInitializer) {
            ((IFinalInitializer)((Object)this)).finalInit(config);
        }
    }

    public final VLMainModule getMainModule() {
        return this.mainModule;
    }

    public ThemeRegistry getThemeRegistry() {
        return this.proxy.getRegistry().getThemeRegistry();
    }

    public ProxyCommon getProxy() {
        return this.proxy;
    }
}

