/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.modifier.attribute.impl;

import com.valkyrieofnight.vlib.modifier.AbstractModifierHandler;
import com.valkyrieofnight.vlib.modifier.attribute.Attribute;
import com.valkyrieofnight.vlib.modifier.attribute.AttributeID;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;

public class IntAddAttribute
extends Attribute<Integer, Integer> {
    public IntAddAttribute(AttributeID id, Integer defaultValue) {
        super(id, defaultValue);
    }

    @Override
    public Integer getFinalized(List<Integer> all) {
        int ret = 0;
        for (Integer i : all) {
            ret += i.intValue();
        }
        return ret;
    }

    @Override
    public Integer getModifiedValue(AbstractModifierHandler modifierHandler, Integer unmodifiedValue) {
        Object fv = modifierHandler.getAttributeFinazliedValueOrDefault(this.getID(), this.defaultValue);
        if (fv == null) {
            return unmodifiedValue;
        }
        return unmodifiedValue + (Integer)fv;
    }

    @Override
    public Integer readFromNBT(CompoundNBT nbt) {
        String id = this.getID().toString();
        if (nbt.func_74764_b(id)) {
            return nbt.func_74762_e(id);
        }
        return (Integer)this.defaultValue;
    }

    @Override
    public CompoundNBT writeToNBT(CompoundNBT nbt, Integer data) {
        nbt.func_74768_a(this.getID().toString(), data.intValue());
        return nbt;
    }
}

