/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.modifier.attribute.impl;

import com.valkyrieofnight.vlib.modifier.AbstractModifierHandler;
import com.valkyrieofnight.vlib.modifier.attribute.Attribute;
import com.valkyrieofnight.vlib.modifier.attribute.AttributeID;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;

public class BoolOrAttribute
extends Attribute<Boolean, Boolean> {
    public BoolOrAttribute(AttributeID id, Boolean defaultValue) {
        super(id, defaultValue);
    }

    @Override
    public Boolean getFinalized(List<Boolean> all) {
        for (Boolean b : all) {
            if (!b.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean getModifiedValue(AbstractModifierHandler modifierHandler, Boolean unmodifiedValue) {
        return (Boolean)modifierHandler.getAttributeFinazliedValueOrDefault(this.getID(), this.defaultValue);
    }

    @Override
    public Boolean readFromNBT(CompoundNBT nbt) {
        String id = this.getID().toString();
        if (nbt.func_74764_b(id)) {
            return nbt.func_74767_n(id);
        }
        return (Boolean)this.defaultValue;
    }

    @Override
    public CompoundNBT writeToNBT(CompoundNBT nbt, Boolean data) {
        nbt.func_74757_a(this.getID().toString(), data.booleanValue());
        return nbt;
    }
}

