/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.modifier.attribute;

import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.client.LangUtil;
import com.valkyrieofnight.vlib.modifier.AbstractModifierHandler;
import com.valkyrieofnight.vlib.modifier.IModifierTile;
import com.valkyrieofnight.vlib.modifier.attribute.AttributeID;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class Attribute<DATA_TYPE, DATA_MODIFIABLE> {
    protected final AttributeID id;
    protected final DATA_TYPE defaultValue;

    public Attribute(AttributeID id, DATA_TYPE defaultValue) {
        this.id = id;
        this.defaultValue = defaultValue;
    }

    public final AttributeID getID() {
        return this.id;
    }

    public final DATA_TYPE getDefaultValue() {
        return this.defaultValue;
    }

    public final DATA_TYPE getValue(ItemStack stack) {
        CompoundNBT nbt = stack.func_190925_c("attributes");
        return this.readFromNBT(nbt);
    }

    public final DATA_TYPE getValue(TileEntity tile) {
        if (tile instanceof IModifierTile) {
            CompoundNBT nbt = ((IModifierTile)tile).getAttributeTag();
            return this.readFromNBT(nbt);
        }
        return this.defaultValue;
    }

    public final DATA_TYPE getOrWriteDefault(@NotNull ItemStack stack) {
        CompoundNBT attributes = stack.func_190925_c("attributes");
        if (attributes == null) {
            attributes = new CompoundNBT();
            this.writeToNBT(attributes, this.getDefaultValue());
        }
        return this.readFromNBT(attributes);
    }

    public abstract DATA_TYPE getFinalized(List<DATA_TYPE> var1);

    public abstract DATA_MODIFIABLE getModifiedValue(AbstractModifierHandler var1, DATA_MODIFIABLE var2);

    public abstract DATA_TYPE readFromNBT(CompoundNBT var1);

    public abstract CompoundNBT writeToNBT(CompoundNBT var1, DATA_TYPE var2);

    public ITextComponent generateTooltip(CompoundNBT nbt) {
        DATA_TYPE value = this.readFromNBT(nbt);
        return new StringTextComponent(LangUtil.toLoc(this.id.getLocalizationKey()) + " : " + value);
    }

    public boolean hasAttribute(CompoundNBT nbt) {
        return nbt.func_74764_b(this.id.toString());
    }
}

