/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.integration.jei.category;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.valkyrieofnight.vlib.core.protection.PlayerID;
import com.valkyrieofnight.vlib.core.util.client.LangUtil;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionDataContainerHandler;
import com.valkyrieofnight.vlib.registry.recipe.AbstractRecipeRegistry;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipe;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipeRegistry;
import java.util.List;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;

public abstract class VLJEIRecipeCategory<T extends VLRecipe, REG extends VLRecipeRegistry<T>>
implements IRecipeCategory<T> {
    protected final ConditionContainerProvider ccp;
    protected final IGuiHelper guiHelper;
    protected final VLID id;
    protected final String title;
    protected final Class<T> recipeClass;

    public VLJEIRecipeCategory(IGuiHelper guiHelper, VLID id, Class<T> recipeClass) {
        this.guiHelper = guiHelper;
        this.id = id;
        this.title = LangUtil.toLoc("jei." + id.func_110624_b() + "." + id.getLocation() + ".title");
        this.recipeClass = recipeClass;
        this.ccp = ConditionDataContainerHandler.getInstance().getProvider(this::getDim, this::getPlayerID);
    }

    public List<T> getAllRecipes() {
        return Lists.newArrayList(this.getRegistry().getAllRecipesForRecipeLookup(this.ccp, this.getRegistryID()));
    }

    public ResourceLocation getUid() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Class<T> getRecipeClass() {
        return this.recipeClass;
    }

    public VLID getRegistryID() {
        return ((AbstractRecipeRegistry)this.getRegistry()).getID();
    }

    public abstract REG getRegistry();

    private DimensionType getDim() {
        return Minecraft.func_71410_x().field_71441_e.func_230315_m_();
    }

    private PlayerID getPlayerID() {
        GameProfile gp = Minecraft.func_71410_x().field_71439_g.func_146103_bH();
        return new PlayerID(gp.getId(), gp.getName());
    }
}

