/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.integration.forge.fluid;

import com.valkyrieofnight.vlib.core.obj.block.base.BlockProps;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Provider;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class FlowingFluidProps
extends BlockProps {
    private ForgeFlowingFluid.Properties props;
    private boolean source = false;
    private boolean canSourcesMultiply = false;
    private int slopeFindDistance = 4;
    private int levelsDecreasedPerBlock = 1;
    private int tickRate = 5;
    private float explosionResistance = 100.0f;
    private Provider<Fluid> sourceProvider;
    private Provider<Fluid> flowingProvider;

    public FlowingFluidProps(Material material) {
        super(material);
    }

    public FlowingFluidProps setProviders(Provider<Fluid> sourceProvider, Provider<Fluid> flowingProvider) {
        this.sourceProvider = sourceProvider;
        this.flowingProvider = flowingProvider;
        return this;
    }

    public ForgeFlowingFluid.Properties getForgeFlowingProperties(FluidAttributes.Builder attributes) {
        return new ForgeFlowingFluid.Properties(this.sourceProvider::request, this.flowingProvider::request, attributes);
    }

    public FlowingFluidProps setSource(boolean opt) {
        this.source = opt;
        return this;
    }

    public FlowingFluidProps setCanSourcesMultiply(boolean opt) {
        this.canSourcesMultiply = opt;
        return this;
    }

    public FlowingFluidProps setSlopeFindDistance(int sfd) {
        this.slopeFindDistance = sfd;
        return this;
    }

    public FlowingFluidProps setLevelsDecreasedPerBlock(int levels) {
        this.levelsDecreasedPerBlock = levels;
        return this;
    }

    public FlowingFluidProps setTickRate(int tickRate) {
        this.tickRate = tickRate;
        return this;
    }

    public FlowingFluidProps setExplosionResistance(float resistance) {
        this.explosionResistance = resistance;
        super.strength(resistance);
        return this;
    }

    public boolean isSource() {
        return this.source;
    }

    public boolean canSourcesMultiply() {
        return this.canSourcesMultiply;
    }

    public int getSlopeFindDistance() {
        return this.slopeFindDistance;
    }

    public int getLevelsDecreasedPerBlock() {
        return this.levelsDecreasedPerBlock;
    }

    public int getTickRate() {
        return this.tickRate;
    }

    public float getExplosionResistance() {
        return this.explosionResistance;
    }
}

