/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.obj;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.annotations.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class TagUtils {
    public static ITag<Block> getBlockTag(ResourceLocation id) {
        return id != null ? (ITag)BlockTags.func_199896_a().func_241833_a().get(id) : null;
    }

    public static ITag<Block> getBlockTag(String id) {
        return id != null ? (ITag)BlockTags.func_199896_a().func_241833_a().get(new ResourceLocation(id)) : null;
    }

    @NotNull
    public static List<Block> getBlocksWithNamespace(@NotNull ITag<Block> tag, @NotNull String namespace) {
        Stream<Block> itemStream = tag.func_230236_b_().stream().filter(itm -> itm.getRegistryName().func_110624_b().equals(namespace));
        return itemStream.collect(Collectors.toList());
    }

    @NotNull
    public static List<Block> getBlocksWithNamespace(@NotNull ITag<Block> tag, String ... namespace) {
        Stream<Block> itemStream = tag.func_230236_b_().stream().filter(itm -> {
            String ins = itm.getRegistryName().func_110624_b();
            for (String ns : namespace) {
                if (!ins.equals(ns)) continue;
                return true;
            }
            return false;
        });
        return itemStream.collect(Collectors.toList());
    }

    public static void addBlockAllNamespaces(List<Block> list, ITag<Block> tag, String ... namespace) {
        List<Block> blocks = TagUtils.getBlocksWithNamespace(tag, namespace);
        for (Block block : blocks) {
            list.add(block);
        }
    }

    public static void addBlockAll(List<Block> list, ITag<Block> tag) {
        for (Block block : tag.func_230236_b_()) {
            list.add(block);
        }
    }

    public static boolean addBlockFirstNamespace(List<Block> list, ITag<Block> tag, String ... namespace) {
        List<Block> blocks = TagUtils.getBlocksWithNamespace(tag, namespace);
        Iterator<Block> iterator = blocks.iterator();
        if (iterator.hasNext()) {
            Block block = iterator.next();
            list.add(block);
            return true;
        }
        return false;
    }

    public static void addAllBlockWithBlacklist(List<Block> list, ITag<Block> tag, String ... blacklist) {
        for (Block block : tag.func_230236_b_()) {
            String namespace = block.getRegistryName().func_110624_b();
            boolean isBlacklisted = false;
            for (String b : blacklist) {
                if (!namespace.equals(b)) continue;
                isBlacklisted = true;
                break;
            }
            if (isBlacklisted) continue;
            list.add(block);
        }
    }

    public static void addBlockPreferred(List<Block> list, ITag<Block> tag, String ... blacklist) {
        boolean hadPreferred = false;
        for (String m : blacklist) {
            ArrayList temp = Lists.newArrayList();
            TagUtils.addBlockAllNamespaces(temp, tag, m);
            if (temp.size() <= 0) continue;
            list.add((Block)temp.get(0));
            hadPreferred = true;
            break;
        }
        if (!hadPreferred) {
            TagUtils.addFirstBlock(list, tag);
        }
    }

    public static void addBlockFirstWithBlacklist(List<Block> list, ITag<Block> tag, String ... blacklist) {
        for (Block block : tag.func_230236_b_()) {
            String namespace = block.getRegistryName().func_110624_b();
            boolean isBlacklisted = false;
            for (String b : blacklist) {
                if (!namespace.equals(b)) continue;
                isBlacklisted = true;
                break;
            }
            if (isBlacklisted) continue;
            list.add(block);
            return;
        }
    }

    public static void addFirstBlock(List<Block> list, ITag<Block> tag) {
        block0: {
            Iterator iterator = tag.func_230236_b_().iterator();
            if (!iterator.hasNext()) break block0;
            Block block = (Block)iterator.next();
            list.add(block);
        }
    }

    public static Optional<ResourceLocation> getBlockTagID(ITag<Block> tag) {
        return Optional.ofNullable(BlockTags.func_199896_a().func_232973_a_(tag));
    }

    public static Optional<ResourceLocation> getFluidTagID(ITag<Fluid> tag) {
        return Optional.ofNullable(FluidTags.func_226157_a_().func_232973_a_(tag));
    }

    public static Optional<ResourceLocation> getItemTagID(ITag<Item> blockITag) {
        return Optional.ofNullable(ItemTags.func_199903_a().func_232973_a_(blockITag));
    }

    @Nullable
    public static ITag<Item> getItemTag(ResourceLocation id) {
        return id != null ? ItemTags.func_199903_a().func_199910_a(id) : null;
    }

    @Nullable
    public static ITag<Item> getItemTag(String id) {
        return id != null ? (ITag)ItemTags.func_199903_a().func_241833_a().get(new ResourceLocation(id)) : null;
    }

    @NotNull
    public static List<Item> getItemsWithNamespace(@NotNull ITag<Item> tag, @NotNull String namespace) {
        Stream<Item> itemStream = tag.func_230236_b_().stream().filter(itm -> itm.getRegistryName().func_110624_b().equals(namespace));
        return itemStream.collect(Collectors.toList());
    }

    @NotNull
    public static List<Item> getItemsWithNamespace(@NotNull ITag<Item> tag, String ... namespaces) {
        Stream<Item> itemStream = tag.func_230236_b_().stream().filter(itm -> {
            String ins = itm.getRegistryName().func_110624_b();
            for (String s : namespaces) {
                if (!ins.equals(s)) continue;
                return true;
            }
            return false;
        });
        return itemStream.collect(Collectors.toList());
    }

    public static boolean addItemAllWhitelisted(@NotNull List<ItemStack> list, @NotNull ITag<Item> tag, int count, String ... whitelist) {
        List<Item> items = TagUtils.getItemsWithNamespace(tag, whitelist);
        for (Item item : items) {
            list.add(new ItemStack((IItemProvider)item, count));
        }
        return !items.isEmpty();
    }

    public static boolean addItemAllWithBlacklist(@NotNull List<ItemStack> list, @NotNull ITag<Item> tag, int count, String ... blacklist) {
        boolean added = false;
        for (Item item : tag.func_230236_b_()) {
            String namespace = item.getRegistryName().func_110624_b();
            boolean isBlacklisted = false;
            for (String b : blacklist) {
                if (!namespace.equals(b)) continue;
                isBlacklisted = true;
                break;
            }
            if (isBlacklisted) continue;
            list.add(new ItemStack((IItemProvider)item, count));
            added = true;
        }
        return added;
    }

    public static boolean addItemFirstPreferred(List<ItemStack> list, ITag<Item> tag, int count, String ... blacklist) {
        boolean hadPreferred = false;
        for (String m : blacklist) {
            ArrayList temp = Lists.newArrayList();
            TagUtils.addItemAllWhitelisted(temp, tag, count, m);
            if (temp.size() <= 0) continue;
            list.add((ItemStack)temp.get(0));
            hadPreferred = true;
            break;
        }
        if (!hadPreferred) {
            return TagUtils.addItemFirst(list, tag, count);
        }
        return false;
    }

    public static boolean addItemFirstWithBlacklist(List<ItemStack> list, ITag<Item> tag, int count, String ... blacklist) {
        for (Item item : tag.func_230236_b_()) {
            String namespace = item.getRegistryName().func_110624_b();
            boolean isBlacklisted = false;
            for (String b : blacklist) {
                if (!namespace.equals(b)) continue;
                isBlacklisted = true;
                break;
            }
            if (isBlacklisted) continue;
            list.add(new ItemStack((IItemProvider)item, count));
            return true;
        }
        return false;
    }

    public static boolean addItemAll(List<ItemStack> list, ITag<Item> tag, int count) {
        boolean added = false;
        for (Item item : tag.func_230236_b_()) {
            list.add(new ItemStack((IItemProvider)item, count));
            added = true;
        }
        return added;
    }

    public static boolean addItemFirstWhitelisted(List<ItemStack> list, ITag<Item> tag, int count, String ... whitelisted) {
        List<Item> items = TagUtils.getItemsWithNamespace(tag, whitelisted);
        Iterator<Item> iterator = items.iterator();
        if (iterator.hasNext()) {
            Item item = iterator.next();
            list.add(new ItemStack((IItemProvider)item, count));
            return true;
        }
        return false;
    }

    public static boolean addItemFirst(List<ItemStack> list, ITag<Item> tag, int count) {
        Iterator iterator = tag.func_230236_b_().iterator();
        if (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            list.add(new ItemStack((IItemProvider)item, count));
            return true;
        }
        return false;
    }

    public static ITag<Fluid> getFluidTag(ResourceLocation id) {
        return id != null ? (ITag)FluidTags.func_226157_a_().func_241833_a().get(id) : null;
    }

    public static ITag<Fluid> getFluidTag(String id) {
        return id != null ? (ITag)FluidTags.func_226157_a_().func_241833_a().get(new ResourceLocation(id)) : null;
    }

    @NotNull
    public static List<Fluid> getFluidsWithNamespace(@NotNull ITag<Fluid> tag, @NotNull String namespace) {
        Stream<Fluid> stream = tag.func_230236_b_().stream().filter(itm -> itm.getRegistryName().func_110624_b().equals(namespace));
        return stream.collect(Collectors.toList());
    }

    @NotNull
    public static List<Fluid> getFluidsWithNamespace(@NotNull ITag<Fluid> tag, String ... namespaces) {
        Stream<Fluid> stream = tag.func_230236_b_().stream().filter(fluid -> {
            String ins = fluid.getRegistryName().func_110624_b();
            for (String s : namespaces) {
                if (!ins.equals(s)) continue;
                return true;
            }
            return false;
        });
        return stream.collect(Collectors.toList());
    }

    public static boolean addFluidAllWhitelisted(List<FluidStack> list, ITag<Fluid> tag, int amt, String ... namespace) {
        List<Fluid> fluids = TagUtils.getFluidsWithNamespace(tag, namespace);
        for (Fluid fluid : fluids) {
            list.add(new FluidStack(fluid, amt));
        }
        return !fluids.isEmpty();
    }

    public static boolean addFluidAll(List<FluidStack> list, ITag<Fluid> tag, int amt) {
        boolean added = false;
        for (Fluid fluid : tag.func_230236_b_()) {
            list.add(new FluidStack(fluid, amt));
            added = true;
        }
        return added;
    }

    public static boolean addFluidFirstPreferred(List<FluidStack> list, ITag<Fluid> tag, int amnt, String[] blacklist) {
        boolean hadPreferred = false;
        for (String m : blacklist) {
            ArrayList temp = Lists.newArrayList();
            TagUtils.addFluidAllWhitelisted(temp, tag, amnt, m);
            if (temp.size() <= 0) continue;
            list.add((FluidStack)temp.get(0));
            hadPreferred = true;
            break;
        }
        if (!hadPreferred) {
            return TagUtils.addFluidFirst(list, tag, amnt);
        }
        return false;
    }

    public static boolean addFluidFirstWithBlacklist(List<FluidStack> list, ITag<Fluid> tag, int count, String[] blacklist) {
        for (Fluid fluid : tag.func_230236_b_()) {
            String namespace = fluid.getRegistryName().func_110624_b();
            boolean isBlacklisted = false;
            for (String b : blacklist) {
                if (!namespace.equals(b)) continue;
                isBlacklisted = true;
                break;
            }
            if (isBlacklisted) continue;
            list.add(new FluidStack(fluid, count));
            return true;
        }
        return false;
    }

    public static boolean addFluidAllWithBlacklist(List<FluidStack> list, ITag<Fluid> tag, int count, String[] blacklist) {
        boolean added = false;
        for (Fluid fluid : tag.func_230236_b_()) {
            String namespace = fluid.getRegistryName().func_110624_b();
            boolean isBlacklisted = false;
            for (String b : blacklist) {
                if (!namespace.equals(b)) continue;
                isBlacklisted = true;
                break;
            }
            if (isBlacklisted) continue;
            list.add(new FluidStack(fluid, count));
            added = true;
        }
        return added;
    }

    public static boolean addFluidFirstWhitelisted(List<FluidStack> list, ITag<Fluid> tag, int amt, String ... whitelist) {
        List<Fluid> fluids = TagUtils.getFluidsWithNamespace(tag, whitelist);
        Iterator<Fluid> iterator = fluids.iterator();
        if (iterator.hasNext()) {
            Fluid fluid = iterator.next();
            list.add(new FluidStack(fluid, amt));
            return true;
        }
        return false;
    }

    public static boolean addFluidFirst(List<FluidStack> list, ITag<Fluid> tag, int amt) {
        Iterator iterator = tag.func_230236_b_().iterator();
        if (iterator.hasNext()) {
            Fluid fluid = (Fluid)iterator.next();
            list.add(new FluidStack(fluid, amt));
            return true;
        }
        return false;
    }
}

