/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.obj;

import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.obj.ItemStackUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryUtils {
    public static boolean canInsertSome(@NotNull IInventory inventory, int slot, @NotNull ItemStack stack) {
        ItemStack existingItemStack = inventory.func_70301_a(slot);
        return existingItemStack.func_190926_b() || ItemStack.func_179545_c((ItemStack)existingItemStack, (ItemStack)stack) && ItemStack.func_77970_a((ItemStack)existingItemStack, (ItemStack)stack) && existingItemStack.func_190916_E() < existingItemStack.func_77976_d();
    }

    public static boolean canInsertAll(@NotNull IInventory inventory, int slot, @NotNull ItemStack stack) {
        ItemStack existingItemStack = inventory.func_70301_a(slot);
        return existingItemStack.func_190926_b() || ItemStack.func_179545_c((ItemStack)existingItemStack, (ItemStack)stack) && ItemStack.func_77970_a((ItemStack)existingItemStack, (ItemStack)stack) && existingItemStack.func_190916_E() + stack.func_190916_E() <= existingItemStack.func_77976_d();
    }

    public static boolean canExtract(@NotNull IInventory inventory, int slot, int amount) {
        ItemStack stack = inventory.func_70301_a(slot);
        return stack.func_190916_E() > amount;
    }

    @NotNull
    public static ItemStack insertItem(IInventory inventory, int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = inventory.func_70301_a(slot);
        if (!stackInSlot.func_190926_b()) {
            if (stackInSlot.func_190916_E() >= Math.min(stackInSlot.func_77976_d(), inventory.func_70297_j_())) {
                return stack;
            }
            if (!ItemStackUtils.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            if (!inventory.func_94041_b(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.func_77976_d(), inventory.func_70297_j_()) - stackInSlot.func_190916_E();
            if (stack.func_190916_E() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190917_f(stackInSlot.func_190916_E());
                    inventory.func_70299_a(slot, copy);
                    inventory.func_70296_d();
                }
                return ItemStack.field_190927_a;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.func_190917_f(stackInSlot.func_190916_E());
                inventory.func_70299_a(slot, copy);
                inventory.func_70296_d();
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!inventory.func_94041_b(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), inventory.func_70297_j_());
        if (m < stack.func_190916_E()) {
            stack = stack.func_77946_l();
            if (!simulate) {
                inventory.func_70299_a(slot, stack.func_77979_a(m));
                inventory.func_70296_d();
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!simulate) {
            inventory.func_70299_a(slot, stack);
            inventory.func_70296_d();
        }
        return ItemStack.field_190927_a;
    }

    @NotNull
    public static ItemStack extractItem(IInventory from, int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = from.func_70301_a(slot);
        if (stackInSlot.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            if (stackInSlot.func_190916_E() < amount) {
                return stackInSlot.func_77946_l();
            }
            ItemStack copy = stackInSlot.func_77946_l();
            copy.func_190920_e(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.func_190916_E(), amount);
        ItemStack decrStackSize = from.func_70298_a(slot, m);
        from.func_70296_d();
        return decrStackSize;
    }

    public static ItemStack moveItem(IInventory fromInventory, int fromSlot, IInventory toInventory, int toSlot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack movedItemStack = fromInventory.func_70301_a(fromSlot).func_77946_l();
        if (movedItemStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (amount < movedItemStack.func_190916_E()) {
            movedItemStack.func_190920_e(amount);
        }
        if (InventoryUtils.canInsertAll(toInventory, toSlot, movedItemStack)) {
            if (!simulate) {
                ItemStack toBeInserted = ItemStackUtils.split(fromInventory.func_70301_a(fromSlot), movedItemStack.func_190916_E());
                if (toInventory.func_70301_a(toSlot).func_190926_b()) {
                    toInventory.func_70299_a(toSlot, toBeInserted);
                } else {
                    toInventory.func_70301_a(toSlot).func_190917_f(movedItemStack.func_190916_E());
                }
            }
            return movedItemStack;
        }
        if (InventoryUtils.canInsertSome(toInventory, toSlot, movedItemStack)) {
            ItemStack toInsertItemStack = toInventory.func_70301_a(toSlot);
            movedItemStack.func_190920_e(toInsertItemStack.func_77976_d() - toInsertItemStack.func_190916_E());
            if (!simulate) {
                toInsertItemStack.func_190920_e(toInsertItemStack.func_77976_d());
                ItemStackUtils.split(fromInventory.func_70301_a(fromSlot), movedItemStack.func_190916_E());
            }
            return movedItemStack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack moveItem(IInventory inventory, int fromSlot, int toSlot, int amount, boolean simulate) {
        return InventoryUtils.moveItem(inventory, fromSlot, inventory, toSlot, amount, simulate);
    }

    public static ItemStack insertStack(IInventory destination, int index, ItemStack stack) {
        ItemStack itemstack = destination.func_70301_a(index);
        if (destination.func_94041_b(index, stack)) {
            if (itemstack.func_190926_b()) {
                destination.func_70299_a(index, stack);
                stack = ItemStack.field_190927_a;
            } else if (ItemStackUtils.canCombine(itemstack, stack)) {
                int i = stack.func_77976_d() - itemstack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190918_g(j);
                itemstack.func_190917_f(j);
            }
        }
        return stack;
    }

    public static ItemStack putStackInInventoryAllSlots(IInventory destination, ItemStack stack) {
        int slots = destination.func_70302_i_();
        for (int i = 0; i < slots && !stack.func_190926_b(); ++i) {
            stack = InventoryUtils.insertStack(destination, i, stack);
        }
        return stack;
    }

    public static boolean canInsertAllShaped(IInventory dest, List<ItemStack> stacks) {
        if (dest.func_70302_i_() < stacks.size()) {
            return false;
        }
        for (int i = 0; i < stacks.size(); ++i) {
            if (InventoryUtils.canInsertAll(dest, i, stacks.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean canExtractAllShaped(IInventory inv, List<ItemStack> req) {
        if (inv.func_70302_i_() < req.size()) {
            return false;
        }
        for (int i = 0; i < req.size(); ++i) {
            if (!ItemStackUtils.canItemStacksStack(inv.func_70301_a(i), req.get(i))) {
                return false;
            }
            if (InventoryUtils.canExtract(inv, i, req.get(i).func_190916_E())) continue;
            return false;
        }
        return true;
    }

    public static boolean canExtractAllShaped(IInventory inv, Map<Integer, ItemStack> req) {
        for (Map.Entry<Integer, ItemStack> e : req.entrySet()) {
            if (!ItemStackUtils.canItemStacksStack(inv.func_70301_a(e.getKey().intValue()), e.getValue())) {
                return false;
            }
            if (InventoryUtils.canExtract(inv, e.getKey(), e.getValue().func_190916_E())) continue;
            return false;
        }
        return true;
    }

    public static ItemStack insertItem(@NotNull IInventory dest, @NotNull ItemStack stack, boolean simulate) {
        int totalSlots = dest.func_70302_i_();
        ItemStack remainder = stack.func_77946_l();
        for (int i = 0; i < totalSlots; ++i) {
            if (remainder.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            remainder = !simulate ? InventoryUtils.insertItem(dest, i, stack, false) : InventoryUtils.insertItem(dest, i, remainder, false);
        }
        return remainder;
    }
}

