/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.math;

import java.util.Random;
import net.minecraft.util.math.BlockPos;

public class MathUtil {
    public static double getDistanceXZ(BlockPos pos, BlockPos pos2) {
        double xr = pos2.func_177958_n() - pos.func_177958_n();
        double zr = pos2.func_177952_p() - pos.func_177952_p();
        return 0.0;
    }

    public static int getRandomRange(Random rand, int min, int max) {
        return rand.nextInt(max - min + 1) + min;
    }

    public static long getRandomRange(Random rand, long min, long max) {
        return MathUtil.nextLong(rand, max - min + 1L) + min;
    }

    public static long nextLong(Random rand, long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException("bound must be positive");
        }
        long r = rand.nextLong();
        long m = bound - 1L;
        if ((bound & m) == 0L) {
            r = bound * r >> 63;
        } else {
            long u = r;
            while (u - (r = u % bound) + m < 0L) {
                u = rand.nextLong();
            }
        }
        return r;
    }

    public static float percentageToMultiplier(int percentage) {
        float perc = Math.abs(percentage);
        return perc / 100.0f;
    }

    public static int multiplierToPercentage(float multiplier) {
        return (int)(100.0f * multiplier);
    }

    public static byte clamp(byte value, byte min, byte max) {
        if (value < min) {
            return min;
        }
        return value > max ? max : value;
    }

    public static short clamp(short value, short min, short max) {
        if (value < min) {
            return min;
        }
        return value > max ? max : value;
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public static long clamp(long value, long min, long max) {
        return Math.max(min, Math.min(max, value));
    }

    public static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    public static int safeAddOrSub(int value, int other) {
        if (other < 0) {
            return MathUtil.safeSub(value, Math.abs(other));
        }
        return MathUtil.safeAdd(value, other);
    }

    public static int safeAdd(int value, int add) {
        if (!MathUtil.willAdditionOverflow(value, add)) {
            return value + add;
        }
        return Integer.MAX_VALUE;
    }

    public static int safeSub(int value, int sub) {
        if (!MathUtil.willSubtractionOverflow(value, sub)) {
            return value - sub;
        }
        return Integer.MIN_VALUE;
    }

    public static boolean willAdditionOverflow(int left, int right) {
        try {
            Math.addExact(left, right);
            return false;
        }
        catch (ArithmeticException e) {
            return true;
        }
    }

    public static boolean willSubtractionOverflow(int left, int right) {
        try {
            Math.subtractExact(left, right);
            return false;
        }
        catch (ArithmeticException e) {
            return true;
        }
    }

    public static int safeLongToInt(long l) {
        if (l < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public static int subtractSmaller(int one, int two) {
        return one < two ? two - one : one - two;
    }

    public static float subtractSmaller(float one, float two) {
        return one < two ? two - one : one - two;
    }

    public static double subtractSmaller(double one, double two) {
        return one < two ? two - one : one - two;
    }

    public static short subtractSmaller(short one, short two) {
        return (short)(one < two ? two - one : one - two);
    }

    public static long subtractSmaller(long one, long two) {
        return one < two ? two - one : one - two;
    }
}

