/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.color;

public class ColorUtil {
    public static final int MC_WHITE = ColorUtil.calcRGBA(255, 255, 255);
    public static final int MC_WHITE_A = ColorUtil.calcRGBA(255, 255, 255, 255);
    public static final int MC_BLACK = ColorUtil.calcRGBA(0, 0, 0);
    public static final int MC_BLACK_A = ColorUtil.calcRGBA(0, 0, 0, 255);

    public static int calcRGBA(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public static int calcRGBA(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int getR(int col) {
        return col >> 16 & 0xFF;
    }

    public static int getG(int col) {
        return col >> 8 & 0xFF;
    }

    public static int getB(int col) {
        return col & 0xFF;
    }

    public static int getA(int col) {
        return col >> 24 & 0xFF;
    }

    public static float getRF(int col) {
        return (float)ColorUtil.getR(col) / 255.0f;
    }

    public static float getGF(int col) {
        return (float)ColorUtil.getG(col) / 255.0f;
    }

    public static float getBF(int col) {
        return (float)ColorUtil.getB(col) / 255.0f;
    }

    public static float getAF(int col) {
        return (float)ColorUtil.getA(col) / 255.0f;
    }

    public static int getR(float col) {
        return (int)(col * 255.0f);
    }

    public static int getG(float col) {
        return (int)(col * 255.0f);
    }

    public static int getB(float col) {
        return (int)(col * 255.0f);
    }

    public static int getA(float col) {
        return (int)(col * 255.0f);
    }
}

