/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.container;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.obj.container.item.base.IVLInventory;
import com.valkyrieofnight.vlib.core.ui.container.InputSlot;
import com.valkyrieofnight.vlib.core.ui.container.ModifierSlot;
import com.valkyrieofnight.vlib.core.ui.container.OutputSlot;
import com.valkyrieofnight.vlib.core.ui.container.VLSlot;
import com.valkyrieofnight.vlib.core.util.annotations.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public abstract class VLContainer
extends Container {
    protected PlayerInventory playerInventory;
    protected PlayerEntity playerEntity;
    protected List<Integer> blockedInteraction = Lists.newArrayList();

    public VLContainer(@Nullable ContainerType<?> type, int windowId, PlayerInventory playerInventory) {
        super(type, windowId);
        this.playerInventory = playerInventory;
        this.playerEntity = playerInventory.field_70458_d;
    }

    protected abstract void setupContainer();

    protected void addSlot(IVLInventory inventoryIn, int index, int x, int y) {
        this.func_75146_a(new VLSlot(inventoryIn, index, x, y));
    }

    protected void addInputSlot(IVLInventory inventory, int index, int x, int y) {
        this.func_75146_a(new InputSlot(inventory, index, x, y));
    }

    protected void addOutputSlot(IVLInventory inventory, int index, int x, int y) {
        this.func_75146_a(new OutputSlot(inventory, index, x, y));
    }

    protected ModifierSlot addModifierSlot(IVLInventory inventory, int index, int x, int y) {
        ModifierSlot m = new ModifierSlot(inventory, index, x, y);
        this.func_75146_a(m);
        return m;
    }

    protected void addPlayerInventory(int invOffsetX, int invOffsetY) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.playerInventory, j + i * 9 + 9, invOffsetX + j * 18, invOffsetY + i * 18));
            }
        }
        int hotbar = 58;
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.playerInventory, i, invOffsetX + i * 18, hotbar + invOffsetY));
        }
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        return super.func_82846_b(playerIn, index);
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        if (this.blockedInteraction.contains(slotIn)) {
            return false;
        }
        return super.func_94530_a(stack, slotIn);
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        if (this.blockedInteraction.contains(slotID)) {
            return;
        }
        super.func_75141_a(slotID, stack);
    }

    public boolean func_94531_b(Slot slotIn) {
        if (this.blockedInteraction.contains(slotIn)) {
            return false;
        }
        return super.func_94531_b(slotIn);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (!this.blockedInteraction.contains(slotId)) {
            return super.func_184996_a(slotId, dragType, clickTypeIn, player);
        }
        return ItemStack.field_190927_a;
    }

    public void blockInteraction(Integer ... slots) {
        this.blockedInteraction.addAll(Arrays.asList(slots));
    }

    public void blockInteraction(Collection<Integer> slots) {
        this.blockedInteraction.addAll(slots);
    }

    public void resetBlockedSlots() {
        this.blockedInteraction = Lists.newArrayList();
    }

    protected static ItemStack quickMoveStack(VLContainer container, IVLInventory tileInventory, PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)container.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < tileInventory.func_70302_i_() ? !container.func_75135_a(itemstack1, tileInventory.func_70302_i_(), container.field_75151_b.size(), true) : !container.func_75135_a(itemstack1, 0, tileInventory.func_70302_i_(), false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
    }
}

