/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import net.minecraft.client.gui.AbstractGui;

public abstract class GuiSizable {
    protected static final AbstractGui DRAWER = new AbstractGui(){};
    protected final VLID texture;
    protected final GuiTexture[][] textures;
    protected final int unitXSize;
    protected final int unitYSize;
    protected final int unitXSizeMiddle;
    protected final int unitYSizeMiddle;
    protected final boolean repeatMiddle;
    protected final int textureWidth;
    protected final int textureHeight;

    protected GuiSizable(VLID tex, int unitCornerX, int unitCornerY, int unitMiddleX, int unitMiddleY, boolean middleRepeatable, int textureWidth, int textureHeight) {
        this.texture = tex;
        this.repeatMiddle = middleRepeatable;
        this.textures = new GuiTexture[3][3];
        this.unitXSize = unitCornerX;
        this.unitYSize = unitCornerY;
        this.unitXSizeMiddle = unitMiddleX;
        this.unitYSizeMiddle = unitMiddleY;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    public String toString() {
        if (this.texture == null) {
            return "null";
        }
        return this.texture.toString();
    }

    protected void setGuiTexture(SizableLocation loc, GuiTexture tex) {
        this.textures[loc.y][loc.x] = tex;
    }

    public GuiTexture getGuiTexture(SizableLocation loc) {
        return this.textures[loc.y][loc.x];
    }

    public VLID getResourceLocation() {
        return this.texture;
    }

    public int getUnitCornerX() {
        return this.unitXSize;
    }

    public int getUnitCornerY() {
        return this.unitYSize;
    }

    public int getUnitMiddleX() {
        return this.unitXSizeMiddle;
    }

    public int getUnitMiddleY() {
        return this.unitYSizeMiddle;
    }

    public boolean getMiddleRepeatable() {
        return this.repeatMiddle;
    }

    public abstract void render(IElementContainer var1, MatrixStack var2, Color4 var3, int var4, int var5, int var6, int var7);

    public static enum SizableLocation {
        TOP_LEFT(0, 0),
        TOP_MID(0, 1),
        TOP_RIGHT(0, 2),
        MID_LEFT(1, 0),
        MID(1, 1),
        MID_RIGHT(1, 2),
        BOT_LEFT(2, 0),
        BOT_MID(2, 1),
        BOT_RIGHT(2, 2);

        public int x;
        public int y;

        private SizableLocation(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

