/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.guage;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.ui.client.renderer.RenderUtils;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDrawTooltip;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementThemeListener;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementUpdate;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.ProgressionDirection;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Provider;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import com.valkyrieofnight.vlib.core.util.tooltip.ITooltipBuilder;
import net.minecraft.nbt.CompoundNBT;

public abstract class AbstractProgressBarElement
extends VLElement
implements IElementDraw,
IElementUpdate,
IElementDrawTooltip,
IElementThemeListener {
    protected int width = this.width;
    protected int height = this.height;
    protected boolean drawToolTip = true;
    private float scale;
    protected ProgressionDirection barDirection;
    private Provider<Float> scaleProvider;
    protected ITooltipBuilder toolTips;

    public AbstractProgressBarElement(String id, ProgressionDirection barDirection, Provider<Float> scaleProvider) {
        super(id);
        this.barDirection = barDirection;
        this.scaleProvider = scaleProvider;
    }

    @Override
    public void renderBg(MatrixStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        RenderUtils.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.renderBar(matrixStack, mouseX, mouseY, partialTicks, this.scale);
    }

    @Override
    public void renderFg(MatrixStack matrixStack, double mouseX, double mouseY) {
    }

    @Override
    public void update() {
        this.scale = MathUtil.clamp(this.scaleProvider.request().floatValue(), 0.0f, 1.0f);
    }

    @Override
    public void drawTooltips(MatrixStack matrixStack, double mouseX, double mouseY) {
        if (!this.drawToolTip) {
            return;
        }
        if (this.withinBoxAndGui(mouseX, mouseY, this.getActualX(), this.getActualY(), this.getSizeX(), this.getSizeY()) && this.toolTips != null) {
            GuiUtils.drawTooltipsList(this.getContainer(), matrixStack, (int)mouseX - this.getContainer().getScreen().getGuiX(), (int)mouseY - this.getContainer().getScreen().getGuiY(), this.toolTips.build());
        }
    }

    public void setToolTips(ITooltipBuilder toolTips) {
        this.toolTips = toolTips;
    }

    protected abstract void renderBar(MatrixStack var1, double var2, double var4, float var6, float var7);

    @Override
    public void load(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        return nbt;
    }
}

