/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.container.scroll;

import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizablePanelElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.FixedContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.ScissorContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base.ElementPosition;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.scroll.ScrollBarElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.Alignment;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;

public abstract class ScrollContainerElement
extends FixedContainerElement {
    private SizablePanelElement background;
    private ScissorContainerElement container;
    private ScrollBarElement hBar;
    private ElementPosition hTabSize;
    private AssetID hTab;
    private AssetID hTabDisabled;
    private int hSpacing;
    private int hScrollSpeed = 10;
    private ScrollBarElement vBar;
    private ElementPosition vTabSize;
    private AssetID vTab;
    private AssetID vTabDisabled;
    private int vSpacing;
    private int vScrollSpeed = 10;

    public ScrollContainerElement(String id, int xSize, int ySize, int hTabWidth, int hTabHeight, int hSpacing, AssetID hTab, AssetID hTabDisabled, int vTabWidth, int vTabHeight, int vSpacing, AssetID vTab, AssetID vTabDisabled) {
        super(id, xSize, ySize);
        this.hTab = hTab;
        this.hTabDisabled = hTabDisabled;
        this.hTabSize = new ElementPosition(hTabWidth, hTabHeight);
        this.hSpacing = hSpacing;
        this.vTab = vTab;
        this.vTabDisabled = vTabDisabled;
        this.vTabSize = new ElementPosition(vTabWidth, vTabHeight);
        this.vSpacing = vSpacing;
    }

    @Override
    public final void addElements() {
        this.container = new ScissorContainerElement("container", this.getSizeX() - this.hSpacing - this.hTabSize.getX(), this.getSizeY() - this.vSpacing - this.vTabSize.getY()){

            @Override
            public final void addElements() {
                ScrollContainerElement.this.addElementsInContainer();
            }

            @Override
            public void addElement(IElement ele, int x, int y) {
                super.addElement(ele, x, y);
                if (ele != null) {
                    int nx = x + ele.getSizeX();
                    int ny = y + ele.getSizeY();
                    if (nx > this.getXScrollMax()) {
                        this.setXScrollMax(nx);
                    }
                    if (ny > this.getYScrollMax()) {
                        this.setYScrollMax(ny);
                    }
                }
            }

            @Override
            public void update() {
                super.update();
            }

            @Override
            public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
                super.mouseClickedResponse(element, mouseX, mouseY, mouseButton);
            }
        };
        this.vBar = new ScrollBarElement("vbar", this.vTabSize.getX(), this.vTabSize.getY(), this.vTab, this.vTabDisabled, Alignment.VERTICAL, this::getYScrollSize, this.container::getYScrollMax, this.container::getYScroll, this::getVScrollSpeed, this.container::onScrollVertical);
        this.hBar = new ScrollBarElement("hbar", this.hTabSize.getX(), this.hTabSize.getY(), this.hTab, this.hTabDisabled, Alignment.HORIZONTAL, this::getXScrollSize, this.container::getXScrollMax, this.container::getXScroll, this::getHScrollSpeed, this.container::onScrollHorizontal);
        super.addElement(this.container, 0, 0);
        super.addElement(this.vBar, this.getSizeX() - this.hTabSize.getX(), 0);
        super.addElement(this.hBar, 0, this.getSizeY() - this.vTabSize.getY());
    }

    @Override
    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        super.mouseClickedResponse(element, mouseX, mouseY, mouseButton);
    }

    public void setMaxScroll(int xScroll, int yScroll) {
        this.container.setScrollMax(xScroll, yScroll);
    }

    public void resetXScroll() {
        this.container.setXScroll(0);
    }

    public void resetYScroll() {
        this.container.setYScroll(0);
    }

    private int getXScrollSize() {
        return this.getSizeX() - 7;
    }

    private int getYScrollSize() {
        return this.getSizeY() - 7;
    }

    @Override
    public void addElement(IElement ele, int x, int y) {
        this.container.addElement(ele, x, y);
    }

    private int getHScrollSpeed() {
        return this.hScrollSpeed;
    }

    private int getVScrollSpeed() {
        return this.vScrollSpeed;
    }

    public abstract void addElementsInContainer();
}

