/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.ContainerButtonElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.image.SequenceImageElement;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;

public abstract class SequenceButton
extends ContainerButtonElement {
    protected int imageX = 0;
    protected int imageY = 0;
    protected SequenceImageElement images;

    public SequenceButton(String id, int xSize, int ySize, int iconSizeX, int iconSizeY, AssetID ... icons) {
        super(id, xSize, ySize);
        this.images = new SequenceImageElement("index", iconSizeX, iconSizeY, icons);
        this.images.setOwner(this);
        if (xSize - iconSizeX != 0) {
            this.imageX = (xSize - iconSizeX) / 2;
        }
        if (ySize - iconSizeY != 0) {
            this.imageY = (ySize - iconSizeY) / 2;
        }
    }

    public int getIndex() {
        return this.images.getIndex();
    }

    public void setIndex(int index) {
        this.images.setIndex(index);
    }

    @Override
    public boolean emouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean clicked = super.emouseClicked(mouseX, mouseY, mouseButton);
        if (clicked) {
            this.images.nextIndex();
        }
        return clicked;
    }

    @Override
    public void renderBg(MatrixStack matrixStack, double mx, double my, float pt) {
        super.renderBg(matrixStack, mx, my, pt);
        this.images.renderBg(matrixStack, mx, my, pt);
    }

    @Override
    public void renderFg(MatrixStack matrixStack, double mx, double my) {
        super.renderFg(matrixStack, mx, my);
        this.images.renderFg(matrixStack, mx, my);
    }

    @Override
    public void onThemeChanged(Theme current) {
        super.onThemeChanged(current);
        this.images.onThemeChanged(current);
    }

    @Override
    public void initContainer() {
        super.initContainer();
        this.images.initContainer();
    }

    @Override
    public int getContainerOffsetX(IElement ele) {
        if (ele == this.images) {
            return this.imageX;
        }
        return 0;
    }

    @Override
    public int getContainerOffsetY(IElement ele) {
        if (ele == this.images) {
            return this.imageY;
        }
        return 0;
    }

    @Override
    public void update() {
        super.update();
        this.images.update();
    }
}

