/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.ui.client.screen.IVLScreen;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.ButtonElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.base.ButtonState;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.FixedContainerElement;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;

public abstract class ContainerButtonElement
extends ButtonElement
implements IElementContainer {
    protected FixedContainerElement en;
    protected FixedContainerElement ho;
    protected FixedContainerElement db;
    protected FixedContainerElement fo;

    public ContainerButtonElement(String id, int xSize, int ySize) {
        super(id, xSize, ySize);
        this.en = new FixedContainerElement("enabled", xSize, ySize){

            @Override
            public void addElements() {
            }
        };
        this.en.setOwner(this);
        this.ho = new FixedContainerElement("hover", xSize, ySize){

            @Override
            public void addElements() {
            }
        };
        this.ho.setOwner(this);
        this.db = new FixedContainerElement("disabled", xSize, ySize){

            @Override
            public void addElements() {
            }
        };
        this.db.setOwner(this);
        this.fo = new FixedContainerElement("focused", xSize, ySize){

            @Override
            public void addElements() {
            }
        };
        this.fo.setOwner(this);
    }

    public abstract void addElements();

    @Override
    protected void drawButtonStateBackground(MatrixStack matrixStack, ButtonState state, double mx, double my, float pt) {
        switch (state) {
            case ENABLED: {
                this.en.renderBg(matrixStack, mx, my, pt);
                break;
            }
            case DISABLED: {
                this.db.renderBg(matrixStack, mx, my, pt);
                break;
            }
            case HOVER: {
                this.ho.renderBg(matrixStack, mx, my, pt);
                break;
            }
            case SELECTED: {
                this.fo.renderBg(matrixStack, mx, my, pt);
            }
        }
    }

    @Override
    protected void drawButtonStateForeground(MatrixStack matrixStack, ButtonState state, double mx, double my) {
        switch (state) {
            case ENABLED: {
                this.en.renderFg(matrixStack, mx, my);
                break;
            }
            case DISABLED: {
                this.db.renderFg(matrixStack, mx, my);
                break;
            }
            case HOVER: {
                this.ho.renderFg(matrixStack, mx, my);
                break;
            }
            case SELECTED: {
                this.fo.renderFg(matrixStack, mx, my);
            }
        }
    }

    public void addElementAllStates(VLElement ele, int x, int y) {
        this.en.addElement(ele, x, y);
        this.ho.addElement(ele, x, y);
        this.db.addElement(ele, x, y);
        this.fo.addElement(ele, x, y);
    }

    public void addElementEach(VLElement enabled, VLElement disabled, VLElement hover, VLElement focused, int x, int y) {
        if (enabled != null) {
            this.en.addElement(enabled, x, y);
        }
        if (hover != null) {
            this.ho.addElement(hover, x, y);
        }
        if (disabled != null) {
            this.db.addElement(disabled, x, y);
        }
        if (focused != null) {
            this.fo.addElement(focused, x, y);
        }
    }

    public void addElementEnabled(VLElement ele, int x, int y) {
        this.en.addElement(ele, x, y);
    }

    public void addElementHover(VLElement ele, int x, int y) {
        this.ho.addElement(ele, x, y);
    }

    public void addElementDisabled(VLElement ele, int x, int y) {
        this.db.addElement(ele, x, y);
    }

    public void addElementFocused(VLElement ele, int x, int y) {
        this.fo.addElement(ele, x, y);
    }

    @Override
    public void onThemeChanged(Theme current) {
        this.en.onThemeChanged(current);
        this.db.onThemeChanged(current);
        this.ho.onThemeChanged(current);
        this.fo.onThemeChanged(current);
    }

    @Override
    public IVLScreen getScreen() {
        return this.getContainer().getScreen();
    }

    @Override
    public void initContainer() {
        this.addElements();
        this.en.initContainer();
        this.db.initContainer();
        this.ho.initContainer();
        this.fo.initContainer();
    }

    @Override
    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    public void mouseReleasedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    public void mouseDraggedResponse(IElement element, double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd) {
    }

    @Override
    public void mouseScrolledResponse(IElement element, double mouseX, double mouseY, double scrolled) {
    }

    @Override
    public void keyPressedResponse(IElement element, int key, int scanCode, int modifiers) {
    }

    @Override
    public void keyReleasedResponse(IElement element, int key, int scanCode, int modifiers) {
    }

    @Override
    public void charTypedResponse(IElement element, char ch, int modifiers) {
    }

    @Override
    public int getContainerOffsetX(IElement ele) {
        return 0;
    }

    @Override
    public int getContainerOffsetY(IElement ele) {
        return 0;
    }

    @Override
    public Theme getTheme() {
        return this.getContainer().getTheme();
    }

    @Override
    public void update() {
        this.en.update();
        this.db.update();
        this.ho.update();
        this.fo.update();
    }
}

