/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.base;

import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementThemeListener;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.util.color.Color4;

public class ElementColor
implements IElementThemeListener {
    private IElement element;
    private Color4 color;
    private AssetID colorID = null;

    public ElementColor(IElement element, AssetID colorID) {
        this(element, Color4.WHITE);
        if (colorID != null && colorID.getType() == AssetID.AssetType.COLOR) {
            this.colorID = colorID;
        }
    }

    public ElementColor(IElement element, Color4 color) {
        this.element = element;
        this.color = color;
    }

    public void override(Color4 color) {
        this.color = color;
        this.colorID = null;
    }

    public void override(AssetID colorID) {
        if (colorID != null && colorID.getType() == AssetID.AssetType.COLOR) {
            this.colorID = colorID;
            if (this.element.getContainer() != null) {
                this.color = this.element.getTheme().getColor(this.colorID);
            }
        }
    }

    public Color4 getColor() {
        return this.color;
    }

    @Override
    public void onThemeChanged(Theme current) {
        if (this.colorID != null) {
            this.color = current.getColor(this.colorID);
        }
    }
}

