/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.ui.client.screen.IVLScreen;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDrawTooltip;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementInput;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementUpdate;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action1a;
import java.util.Collection;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public abstract class IndexElement<TYPE extends IElement>
extends VLElement
implements IElementContainer,
IElementDraw,
IElementInput {
    private Map<String, TYPE> indices = Maps.newHashMap();
    private Map<String, Integer> idToNum = Maps.newHashMap();
    private Map<Integer, String> numToId = Maps.newHashMap();
    private int totalIndices = 0;
    private String currentIndex;
    private Action1a<IElement> onIndexChangedListener;

    public IndexElement(String id) {
        super(id);
    }

    public void forEach(Action1a<IElement> action) {
        if (action == null) {
            return;
        }
        for (IElement e : this.indices.values()) {
            action.execute(e);
        }
    }

    public void setOnIndexChangedListener(Action1a<IElement> listener) {
        if (listener != null) {
            this.onIndexChangedListener = listener;
        }
    }

    @Override
    public final void load(CompoundNBT nbt) {
        CompoundNBT tn = nbt.func_74775_l(this.getID());
        this.setIndex(tn.func_74779_i("index"));
        this.getCurrentIndex().load(nbt);
    }

    @Override
    public final CompoundNBT save(CompoundNBT nbt) {
        CompoundNBT tn = new CompoundNBT();
        tn.func_74778_a("index", this.currentIndex);
        this.getCurrentIndex().save(tn);
        nbt.func_218657_a(this.getID(), (INBT)tn);
        return nbt;
    }

    @Override
    public int getSizeX() {
        IElement ele = (IElement)this.indices.get(this.currentIndex);
        return ele != null ? ele.getSizeX() : 0;
    }

    @Override
    public int getSizeY() {
        IElement ele = (IElement)this.indices.get(this.currentIndex);
        return ele != null ? ele.getSizeY() : 0;
    }

    @Override
    public IVLScreen getScreen() {
        return this.getContainer().getScreen();
    }

    @Override
    public Theme getTheme() {
        return this.getContainer().getTheme();
    }

    @Override
    public int getContainerOffsetX(IElement ele) {
        return 0;
    }

    @Override
    public int getContainerOffsetY(IElement ele) {
        return 0;
    }

    @Override
    public void update() {
        IElement ele = (IElement)this.indices.get(this.currentIndex);
        if (ele != null && ele instanceof IElementUpdate) {
            ((IElementUpdate)((Object)ele)).update();
        }
    }

    @Override
    public void renderBg(MatrixStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        IElement ele = (IElement)this.indices.get(this.currentIndex);
        if (ele instanceof IElementDraw && ((IElementDraw)((Object)ele)).isBgVisible()) {
            ((IElementDraw)((Object)ele)).renderBg(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void renderFg(MatrixStack matrixStack, double mouseX, double mouseY) {
        IElement ele = (IElement)this.indices.get(this.currentIndex);
        if (ele instanceof IElementDraw && ((IElementDraw)((Object)ele)).isFgVisible()) {
            ((IElementDraw)((Object)ele)).renderFg(matrixStack, mouseX, mouseY);
        }
    }

    @Override
    public void drawTooltips(MatrixStack matrixStack, double mouseX, double mouseY) {
        IElement ele = (IElement)this.indices.get(this.currentIndex);
        if (ele instanceof IElementDrawTooltip) {
            ((IElementDrawTooltip)((Object)ele)).drawTooltips(matrixStack, mouseX, mouseY);
        }
    }

    @Override
    public boolean emouseClicked(double mouseX, double mouseY, int mouseButton) {
        IElement ele = (IElement)this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).emouseClicked(mouseX, mouseY, mouseButton)) {
            this.mouseClickedResponse(ele, mouseX, mouseY, mouseButton);
            return true;
        }
        return false;
    }

    @Override
    public boolean emouseReleased(double mouseX, double mouseY, int mouseButton) {
        IElement ele = (IElement)this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).emouseReleased(mouseX, mouseY, mouseButton)) {
            this.mouseReleasedResponse(ele, mouseX, mouseY, mouseButton);
            return true;
        }
        return false;
    }

    @Override
    public boolean emouseDragged(double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd) {
        IElement ele = (IElement)this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).emouseDragged(mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd)) {
            this.mouseDraggedResponse(ele, mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd);
            return true;
        }
        return false;
    }

    @Override
    public boolean emouseScrolled(double mouseX, double mouseY, double scrolled) {
        IElement ele = (IElement)this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).emouseScrolled(mouseX, mouseY, scrolled)) {
            this.mouseScrolledResponse(ele, mouseX, mouseY, scrolled);
            return true;
        }
        return false;
    }

    @Override
    public boolean ekeyPressed(int key, int scanCode, int modifiers) {
        IElement ele = (IElement)this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).ekeyPressed(key, scanCode, modifiers)) {
            this.keyPressedResponse(ele, key, scanCode, modifiers);
            return true;
        }
        return false;
    }

    @Override
    public boolean ekeyReleased(int key, int scanCode, int modifiers) {
        IElement ele = (IElement)this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).ekeyReleased(key, scanCode, modifiers)) {
            this.keyReleasedResponse(ele, key, scanCode, modifiers);
            return true;
        }
        return false;
    }

    @Override
    public boolean echarTyped(char ch, int modifiers) {
        IElement ele = (IElement)this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).echarTyped(ch, modifiers)) {
            this.charTypedResponse(ele, ch, modifiers);
            return true;
        }
        return false;
    }

    public void addIndex(TYPE index) {
        if (index != null) {
            this.indices.put(index.getRawID(), index);
            this.idToNum.put(index.getRawID(), this.totalIndices);
            this.numToId.put(this.totalIndices, index.getRawID());
            ++this.totalIndices;
            index.setOwner(this);
            if (StringUtils.isNullOrEmpty(this.currentIndex)) {
                this.currentIndex = index.getRawID();
            }
        }
    }

    @Override
    public final void initContainer() {
        this.addIndices();
        GuiUtils.initContainerAll(this.indices.values());
    }

    public abstract void addIndices();

    public boolean hasIndex(String indexID) {
        if (StringUtils.isNullOrEmpty(indexID)) {
            return false;
        }
        return this.indices.containsKey(indexID);
    }

    public boolean setIndex(String indexID) {
        if (this.hasIndex(indexID)) {
            this.currentIndex = indexID;
            if (this.onIndexChangedListener != null) {
                this.onIndexChangedListener.execute((IElement)this.getIndex(this.currentIndex));
            }
            return true;
        }
        return false;
    }

    public TYPE getCurrentIndex() {
        return (TYPE)((IElement)this.indices.get(this.currentIndex));
    }

    public int getNumberIndex() {
        return this.idToNum.get(this.currentIndex);
    }

    public TYPE getIndex(String index) {
        if (!this.indices.containsKey(index)) {
            return null;
        }
        return (TYPE)((IElement)this.indices.get(index));
    }

    public Collection<TYPE> getAllIndices() {
        return this.indices.values();
    }

    public boolean setIndex(int index) {
        return this.setIndex(this.numToId.get(index % this.totalIndices));
    }

    public String getNextIndex() {
        int next = this.idToNum.get(this.currentIndex) + 1;
        if (next < this.indices.size()) {
            return this.numToId.get(next);
        }
        return this.numToId.get(0);
    }

    public String getPrevIndex() {
        int prev = this.idToNum.get(this.currentIndex) - 1;
        if (prev >= 0) {
            return this.numToId.get(prev);
        }
        return this.numToId.get(this.indices.size() - 1);
    }

    public boolean hasNextIndex() {
        return this.idToNum.get(this.currentIndex) < this.indices.size() - 1;
    }

    public boolean hasPrevIndex() {
        return this.idToNum.get(this.currentIndex) > 0;
    }

    public boolean isCurrentIndex(String index) {
        return index != null ? index.equals(this.currentIndex) : false;
    }

    @Override
    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        this.getContainer().mouseClickedResponse(element, mouseX, mouseY, mouseButton);
    }

    @Override
    public void mouseReleasedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        this.getContainer().mouseReleasedResponse(element, mouseX, mouseY, mouseButton);
    }

    @Override
    public void mouseDraggedResponse(IElement element, double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd) {
        this.getContainer().mouseDraggedResponse(element, mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd);
    }

    @Override
    public void mouseScrolledResponse(IElement element, double mouseX, double mouseY, double scrolled) {
        this.getContainer().mouseScrolledResponse(element, mouseX, mouseY, scrolled);
    }

    @Override
    public void keyPressedResponse(IElement element, int key, int scanCode, int modifiers) {
        this.getContainer().keyPressedResponse(element, key, scanCode, modifiers);
    }

    @Override
    public void keyReleasedResponse(IElement element, int key, int scanCode, int modifiers) {
        this.getContainer().keyReleasedResponse(element, key, scanCode, modifiers);
    }

    @Override
    public void charTypedResponse(IElement element, char ch, int modifiers) {
        this.getContainer().charTypedResponse(element, ch, modifiers);
    }

    @Override
    public void onThemeChanged(Theme current) {
        GuiUtils.onThemeChangedAll(current, this.indices.values());
    }
}

