/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.tileentity.module.machine;

import com.valkyrieofnight.vlib.core.obj.container.item.VLInventory;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.TrackerModule;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.machine.recipe.II1O1MachineRecipe;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.machine.recipe.II1O1MachineRecipeRegistry;
import com.valkyrieofnight.vlib.core.util.obj.InventoryUtils;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import net.minecraft.item.ItemStack;

public class I1O1MachineModule
extends TrackerModule {
    protected VLInventory in;
    protected VLInventory out;
    protected ConditionContainerProvider ccp;
    protected II1O1MachineRecipeRegistry registry;
    protected II1O1MachineRecipe recipe;

    protected I1O1MachineModule() {
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    protected boolean canStartProcess() {
        if (this.recipe == null || !this.recipe.testInput(this.ccp, this.in.func_70301_a(0))) {
            this.recipe = this.registry.getRecipe(this.ccp, this.in.func_70301_a(0));
        }
        if (this.recipe != null) {
            return this.isRecipeValid() && InventoryUtils.canInsertAll(this.out, 0, this.recipe.getOutput(this.ccp)) && super.canStartProcess();
        }
        return false;
    }

    protected boolean isRecipeValid() {
        int costCount = this.recipe.getInputCount(this.ccp);
        return this.recipe.testInput(this.ccp, this.in.func_70301_a(0)) && InventoryUtils.canExtract(this.in, 0, costCount);
    }

    @Override
    protected int validateProcessable(int ticks) {
        if (this.recipe == null || !this.recipe.testInput(this.ccp, this.in.func_70301_a(0))) {
            this.reset();
        }
        return super.validateProcessable(ticks);
    }

    @Override
    protected boolean canCompleteProcess() {
        if (this.recipe == null || !this.isRecipeValid()) {
            this.reset();
            return false;
        }
        if (this.out.func_70301_a(0).equals(ItemStack.field_190927_a)) {
            return super.canCompleteProcess();
        }
        ItemStack o = this.recipe.getOutput(this.ccp);
        if (InventoryUtils.canInsertAll(this.out, 0, o)) {
            return super.canCompleteProcess();
        }
        return false;
    }

    @Override
    protected void onProcessTicks(int ticks) {
        if (this.recipe == null) {
            this.reset();
        } else {
            super.onProcessTicks(ticks);
        }
    }

    @Override
    protected void onCompleteProcess() {
        ItemStack o = this.recipe.getOutput(this.ccp);
        InventoryUtils.extractItem(this.in, 0, this.recipe.getInputCount(this.ccp), false);
        InventoryUtils.insertItem(this.out, 0, o, false);
        super.onCompleteProcess();
    }

    public static abstract class AbstractBuilder<MODULE extends I1O1MachineModule, BUILDER extends AbstractBuilder<MODULE, BUILDER>>
    extends TrackerModule.AbstractBuilder<MODULE, BUILDER> {
        protected volatile VLInventory in;
        protected volatile VLInventory out;
        protected volatile ConditionContainerProvider ccp;
        protected volatile II1O1MachineRecipeRegistry registry;

        protected AbstractBuilder(VLInventory in, VLInventory out, ConditionContainerProvider ccp, II1O1MachineRecipeRegistry registry) {
            this.in = in;
            this.out = out;
            this.ccp = ccp;
            this.registry = registry;
        }

        @Override
        protected MODULE addInternals(MODULE module) {
            if (this.in == null || this.out == null || this.ccp == null || this.registry == null) {
                throw new NullPointerException("I1O1MachineModule cannot contain null values");
            }
            ((I1O1MachineModule)module).in = this.in;
            ((I1O1MachineModule)module).out = this.out;
            ((I1O1MachineModule)module).ccp = this.ccp;
            ((I1O1MachineModule)module).registry = this.registry;
            return (MODULE)((I1O1MachineModule)super.addInternals(module));
        }
    }

    public static final class Builder
    extends AbstractBuilder<I1O1MachineModule, Builder> {
        protected Builder(VLInventory in, VLInventory out, ConditionContainerProvider ccp, II1O1MachineRecipeRegistry registry) {
            super(in, out, ccp, registry);
        }

        @Override
        protected I1O1MachineModule newModule() {
            return new I1O1MachineModule();
        }

        @Override
        public Builder thisBuilder() {
            return this;
        }
    }
}

