/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.tileentity.module;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.Module;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.base.IModuleBuilder;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.base.ISidedTickerModule;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.base.ITickClient;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.base.ITickCommon;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.base.ITickServer;
import java.util.List;
import net.minecraft.tileentity.TileEntity;

public class SidedTickerModule
extends Module
implements ITickClient,
ITickCommon,
ITickServer {
    protected volatile ITickClient clientTick;
    protected volatile ITickCommon commonTick;
    protected volatile ITickServer serverTick;
    protected volatile List<? extends ISidedTickerModule> sidedModules;

    protected SidedTickerModule() {
    }

    @Override
    public <T extends TileEntity> void tick(T te) {
        super.tick(te);
        if (!te.func_145831_w().func_201670_d()) {
            this.serverTick();
        } else {
            this.clientTick();
        }
        this.commonTick();
    }

    @Override
    public void clientTick() {
        this.clientTick.clientTick();
        this.sidedModules.forEach(m -> m.clientTick());
    }

    @Override
    public void commonTick() {
        this.commonTick.commonTick();
        this.sidedModules.forEach(m -> m.commonTick());
    }

    @Override
    public void serverTick() {
        this.serverTick.serverTick();
        this.sidedModules.forEach(m -> m.serverTick());
    }

    public static abstract class AbstractBuilder<MODULE extends SidedTickerModule, BUILDER extends AbstractBuilder<MODULE, ?>>
    extends Module.AbstractBuilder<MODULE, BUILDER> {
        protected ITickClient tickClient;
        protected ITickCommon tickCommon;
        protected ITickServer tickServer;
        protected List<ISidedTickerModule> sidedModules = Lists.newArrayList();

        protected AbstractBuilder() {
        }

        @Override
        protected MODULE addInternals(MODULE module) {
            ((SidedTickerModule)module).serverTick = this.tickServer != null ? this.tickServer : () -> {};
            ((SidedTickerModule)module).commonTick = this.tickCommon != null ? this.tickCommon : () -> {};
            ((SidedTickerModule)module).clientTick = this.tickClient != null ? this.tickClient : () -> {};
            ((SidedTickerModule)module).sidedModules = this.sidedModules;
            return (MODULE)((SidedTickerModule)super.addInternals(module));
        }

        @Override
        public BUILDER addModule(IModuleBuilder<? extends Module, ? extends Module.AbstractBuilder> builder) {
            if (builder != null) {
                Module m = builder.build();
                this.subModules.add(m);
                if (m instanceof ISidedTickerModule) {
                    this.sidedModules.add((ISidedTickerModule)((Object)m));
                }
            }
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER clientTick(ITickClient tick) {
            this.tickClient = tick;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER commonTick(ITickCommon tick) {
            this.tickCommon = tick;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER serverTick(ITickServer tick) {
            this.tickServer = tick;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }
    }

    public static final class Builder
    extends AbstractBuilder<SidedTickerModule, Builder> {
        protected Builder() {
        }

        @Override
        protected SidedTickerModule newModule() {
            return new SidedTickerModule();
        }

        @Override
        public Builder thisBuilder() {
            return this;
        }
    }
}

