/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.container.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.obj.container.item.base.IInventoryProvider;
import com.valkyrieofnight.vlib.core.obj.container.item.base.IVLInventory;
import com.valkyrieofnight.vlib.core.obj.container.item.base.IVLMultiInventory;
import com.valkyrieofnight.vlib.core.obj.container.item.base.IVLSerializableInventory;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Function2a;
import com.valkyrieofnight.vlib.core.util.math.IntRange;
import com.valkyrieofnight.vlib.core.util.obj.IOMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class VLMultiInventory
implements IVLMultiInventory,
IInventoryProvider {
    protected int inventorySize = 0;
    protected List<IVLSerializableInventory> inventories = Lists.newArrayList();
    protected Map<Integer, IVLSerializableInventory> inventoryMap = Maps.newHashMap();
    protected Map<Integer, IntRange> rangeMap = Maps.newHashMap();
    private List<IInventoryChangedListener> listeners;

    public VLMultiInventory(IVLSerializableInventory ... invs) {
        this.inventories.addAll(Arrays.asList(invs));
        this.recalculateInventory();
    }

    public VLMultiInventory(List<IVLSerializableInventory> inventories) {
        this.inventories.addAll(inventories);
        this.recalculateInventory();
    }

    @Override
    public IVLSerializableInventory copy(boolean withData) {
        ArrayList inventories = Lists.newArrayList();
        for (IVLSerializableInventory inv : this.inventories) {
            inventories.add(inv.copy(withData));
        }
        return new VLMultiInventory(inventories);
    }

    @Override
    public IVLSerializableInventory copyWithValidators(boolean withData) {
        ArrayList inventories = Lists.newArrayList();
        for (IVLSerializableInventory inv : this.inventories) {
            inventories.add(inv.copyWithValidators(withData));
        }
        return new VLMultiInventory(inventories);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        IVLInventory inv;
        int id = this.getInventoryIDFromSlot(index);
        if (id > -1 && (inv = (IVLInventory)this.inventoryMap.get(id)) != null) {
            IntRange ir = this.rangeMap.get(id);
            return inv.func_94041_b(ir.getPosition(index), stack);
        }
        return false;
    }

    public IVLInventory getByID(int id) {
        if (this.inventoryMap.containsKey(id)) {
            return this.inventoryMap.get(id);
        }
        return null;
    }

    public IVLInventory getBySlotIndex(int index) {
        int id = this.getInventoryIDFromSlot(index);
        if (id > -1) {
            return this.inventoryMap.get(id);
        }
        return null;
    }

    public IntRange getRange(int id) {
        if (this.rangeMap.containsKey(id)) {
            return this.rangeMap.get(id);
        }
        return new IntRange(0, 0);
    }

    public void recalculateInventory() {
        this.inventorySize = 0;
        this.rangeMap = Maps.newHashMap();
        this.inventoryMap = Maps.newHashMap();
        int id = 0;
        int totals = 0;
        int totalsEnd = 0;
        for (IVLSerializableInventory inv : this.inventories) {
            this.inventoryMap.put(id, inv);
            this.rangeMap.put(id, new IntRange(totals, totalsEnd += inv.func_70302_i_()));
            this.inventorySize += inv.func_70302_i_();
            ++id;
            totals = totalsEnd;
        }
    }

    public void addListener(IInventoryChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(IInventoryChangedListener listener) {
        this.listeners.remove(listener);
    }

    private int getInventoryIDFromSlot(int slot) {
        for (Integer id : this.rangeMap.keySet()) {
            IntRange r = this.rangeMap.get(id);
            if (!r.isInRange(slot)) continue;
            return id;
        }
        return -1;
    }

    @Override
    public IVLInventory getInventoryFromSlot(int slot) {
        int id = this.getInventoryIDFromSlot(slot);
        return this.inventoryMap.get(id);
    }

    private ItemStack changeSlot(int index, Function2a<IVLInventory, IntRange, ItemStack> stuff) {
        IVLInventory inv;
        int id = this.getInventoryIDFromSlot(index);
        if (id > -1 && (inv = (IVLInventory)this.inventoryMap.get(id)) != null) {
            this.func_70296_d();
            IntRange ir = this.rangeMap.get(id);
            return stuff.execute(inv, ir);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int getMaxStackSize(int slot) {
        return this.getInventoryFromSlot(slot).getMaxStackSize(slot);
    }

    public int func_70297_j_() {
        return this.getMaxStackSize(0);
    }

    public int func_70302_i_() {
        return this.inventorySize;
    }

    public boolean func_191420_l() {
        for (IVLInventory iVLInventory : this.inventories) {
            if (iVLInventory.func_191420_l()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        IVLInventory inv;
        int id = this.getInventoryIDFromSlot(index);
        if (id > -1 && (inv = (IVLInventory)this.inventoryMap.get(id)) != null) {
            IntRange ir = this.rangeMap.get(id);
            return inv.func_70301_a(ir.getPosition(index));
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.changeSlot(index, (inv, ir) -> inv.func_70298_a(ir.getPosition(index), count));
    }

    public ItemStack func_70304_b(int index) {
        return this.changeSlot(index, (inv, ir) -> inv.func_70304_b(ir.getPosition(index)));
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.changeSlot(index, (inv, ir) -> {
            inv.func_70299_a(ir.getPosition(index), stack);
            return ItemStack.field_190927_a;
        });
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_70296_d() {
        if (this.listeners != null) {
            for (IInventoryChangedListener listener : this.listeners) {
                listener.func_76316_a((IInventory)this);
            }
        }
    }

    public void func_174888_l() {
        for (IVLInventory iVLInventory : this.inventories) {
            iVLInventory.func_174888_l();
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        for (Integer i : this.inventoryMap.keySet()) {
            IVLSerializableInventory inv = this.inventoryMap.get(i);
            nbt.func_218657_a("" + i, (INBT)inv.serializeNBT());
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        for (Integer i : this.inventoryMap.keySet()) {
            IVLSerializableInventory inv = this.inventoryMap.get(i);
            inv.deserializeNBT(nbt.func_74775_l("" + i));
        }
        this.recalculateInventory();
    }

    @Override
    public IOMode getSlotMode(int slot) {
        int id = this.getInventoryIDFromSlot(slot);
        return this.getInventoryFromSlot(slot).getSlotMode(this.rangeMap.get(id).getPosition(slot));
    }

    @Override
    public List<IOMode> getSlotModes() {
        ArrayList modes = Lists.newArrayList();
        for (Integer invID : this.inventoryMap.keySet()) {
            modes.addAll(this.inventoryMap.get(invID).getSlotModes());
        }
        return modes;
    }
}

