/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.container.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.io.nbt.INBTSerializer;
import com.valkyrieofnight.vlib.core.util.math.RelativeDirection;
import com.valkyrieofnight.vlib.core.util.obj.IOMode;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.nbt.CompoundNBT;

public class SidedConfigWL
implements INBTSerializer {
    private final String name;
    private final List<RelativeDirection> disabledDirections;
    private final List<IOMode> io;
    private boolean dirty;
    protected ConcurrentMap<RelativeDirection, List<Integer>> enabled = Maps.newConcurrentMap();

    public SidedConfigWL(String name, Collection<RelativeDirection> disabled, List<IOMode> slots) {
        this.name = name;
        this.disabledDirections = Lists.newArrayList(disabled);
        this.io = slots;
        this.setupMap();
    }

    public SidedConfigWL(String name, RelativeDirection[] disabled, List<IOMode> slots) {
        this(name, Lists.newArrayList((Object[])disabled), slots);
    }

    private void setupMap() {
        for (RelativeDirection rd : RelativeDirection.getALL()) {
            if (this.disabledDirections.contains((Object)rd)) continue;
            this.enabled.put(rd, Lists.newArrayList());
        }
    }

    private boolean isDisabled(RelativeDirection rd) {
        return this.disabledDirections.contains((Object)rd);
    }

    public void setChanged() {
        this.dirty = true;
    }

    public String getName() {
        return this.name;
    }

    public boolean cleanIfDirty() {
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        return false;
    }

    public SidedConfigWL copy() {
        SidedConfigWL n = new SidedConfigWL(this.name, this.disabledDirections, this.io);
        this.enabled.forEach((k, v) -> v.forEach(c -> n.enableDirection((Integer)c, (RelativeDirection)((Object)k))));
        return n;
    }

    public void debug() {
        for (RelativeDirection rd : this.enabled.keySet()) {
            if (this.disabledDirections.contains((Object)rd)) continue;
            List list = (List)this.enabled.get((Object)rd);
        }
    }

    public boolean isEnabled(Integer slot, RelativeDirection direction) {
        if (this.isDisabled(direction)) {
            return false;
        }
        List slots = (List)this.enabled.get((Object)direction);
        if (slots != null) {
            return slots.contains(slot);
        }
        return false;
    }

    public boolean isEnabledAny(Integer slot) {
        for (RelativeDirection rd : RelativeDirection.getALL()) {
            if (this.isDisabled(rd) || !this.enabled.containsKey((Object)rd) || !((List)this.enabled.get((Object)rd)).contains(slot)) continue;
            return true;
        }
        return false;
    }

    public boolean enableDirection(Integer slot, RelativeDirection rd) {
        if (this.isDisabled(rd)) {
            return false;
        }
        List<Integer> slots = this.enabled.getOrDefault((Object)rd, Lists.newArrayList());
        if (!slots.contains(slot)) {
            slots.add(slot);
            this.setChanged();
        }
        this.enabled.put(rd, slots);
        return true;
    }

    public boolean disableDirection(Integer slot, RelativeDirection rd) {
        if (this.isDisabled(rd)) {
            return false;
        }
        List<Integer> slots = this.enabled.getOrDefault((Object)rd, Lists.newArrayList());
        if (slots.contains(slot)) {
            slots.remove(slot);
            this.setChanged();
        }
        this.enabled.put(rd, slots);
        return true;
    }

    public boolean disableAllDirections(Integer slot) {
        if (this.disabledDirections.size() == 6) {
            return false;
        }
        for (RelativeDirection direction : RelativeDirection.getALL()) {
            List<Integer> slots = this.enabled.getOrDefault((Object)direction, Lists.newArrayList());
            if (slots.contains(slot)) {
                slots.remove(slot);
                this.setChanged();
            }
            this.enabled.put(direction, slots);
        }
        return true;
    }

    public void disableSlotAllDirections(Integer slot) {
        for (RelativeDirection rd : RelativeDirection.getALL()) {
            this.disableDirection(slot, rd);
        }
    }

    public void enableSlotAllDirections(Integer slot) {
        for (RelativeDirection rd : RelativeDirection.getALL()) {
            this.enableDirection(slot, rd);
        }
    }

    public boolean canInsert(Integer slot, RelativeDirection direction) {
        if (slot >= 0 && slot < this.io.size()) {
            IOMode im = this.io.get(slot);
            return this.isEnabled(slot, direction) && (im == IOMode.IN || im == IOMode.BOTH);
        }
        return false;
    }

    public boolean canExtract(Integer slot, RelativeDirection direction) {
        if (slot >= 0 && slot < this.io.size()) {
            IOMode im = this.io.get(slot);
            return this.isEnabled(slot, direction) && (im == IOMode.OUT || im == IOMode.BOTH);
        }
        return false;
    }

    public int[] getEnabledSlotsForDirection(RelativeDirection rd) {
        if (!this.enabled.containsKey((Object)rd)) {
            return new int[0];
        }
        int[] slots = new int[((List)this.enabled.get((Object)rd)).size()];
        List slotsL = (List)this.enabled.get((Object)rd);
        for (int i = 0; i < slotsL.size(); ++i) {
            slots[i] = (Integer)slotsL.get(i);
        }
        return slots;
    }

    public int getTotalSlots() {
        return this.io.size();
    }

    public List<RelativeDirection> getDisabledDirections() {
        return this.disabledDirections;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        for (RelativeDirection rd : this.enabled.keySet()) {
            List slots = (List)this.enabled.get((Object)rd);
            nbt.func_197646_b(rd.name(), slots);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.enabled = Maps.newConcurrentMap();
        for (RelativeDirection rd : RelativeDirection.getALL()) {
            int[] slots;
            if (!nbt.func_74764_b(rd.name()) || (slots = nbt.func_74759_k(rd.name())).length <= 0) continue;
            for (int i = 0; i < slots.length; ++i) {
                this.enableDirection(slots[i], rd);
            }
        }
    }
}

