/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.json.config.property.properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropBase;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropParserBase;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;

public class PropFloat
extends PropBase<Float> {
    public static final PropFloatParser PARSER = new PropFloatParser();
    protected float min;
    protected float max;

    public PropFloat(float value, float min, float max) {
        super(Float.valueOf(value));
        this.min = min;
        this.max = max;
    }

    public PropFloat(float value) {
        this(value, Float.MIN_VALUE, Float.MAX_VALUE);
    }

    @Override
    public String getExtra() {
        return "[" + this.min + "~" + this.max + "]";
    }

    @Override
    protected Float validateData(Float data) {
        return Float.valueOf(MathUtil.clamp(data.floatValue(), this.min, this.max));
    }

    @Override
    public PropParserBase getParser() {
        return PARSER;
    }

    protected static class PropFloatParser
    extends PropParserBase<PropFloat> {
        public PropFloatParser() {
            super("fl");
        }

        @Override
        public PropFloat fromJson(@NotNull JsonElement json) throws Exception {
            return new PropFloat(json.getAsFloat());
        }

        @Override
        public JsonElement toJson(@NotNull PropFloat prop) throws Exception {
            return new JsonPrimitive((Number)prop.getValue());
        }
    }
}

