/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.datapack;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.valkyrieofnight.vlib.core.io.datapack.IDataRegistryReloader;
import com.valkyrieofnight.vlib.core.io.json.ITypedDeserializer;
import com.valkyrieofnight.vlib.core.io.json.JsonUtils;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import org.apache.commons.io.IOUtils;

public abstract class JsonDataLoader<DATA_TYPE, REGISTRY extends IDataRegistryReloader<DATA_TYPE>>
implements IFutureReloadListener {
    private String modid;
    private String folder;
    protected Gson gson;
    protected String fileExtension;
    private REGISTRY registry;
    private final Class<DATA_TYPE> dataClass;

    public JsonDataLoader(String modid, String dataFolder, Class<DATA_TYPE> dataClass, REGISTRY registry, Gson gson) {
        this(modid, dataFolder, dataClass, registry);
        this.fileExtension = ".json";
        this.gson = gson;
    }

    public JsonDataLoader(String modid, String dataFolder, Class<DATA_TYPE> dataClass, REGISTRY registry, ITypedDeserializer ... deserializers) {
        this(modid, dataFolder, dataClass, registry);
        this.fileExtension = ".json";
        this.gson = JsonUtils.createTypedGsonBuilder(deserializers).create();
    }

    protected JsonDataLoader(String modid, String dataFolder, Class<DATA_TYPE> dataClass, REGISTRY registry) {
        this.modid = modid;
        this.folder = dataFolder;
        this.dataClass = dataClass;
        this.registry = registry;
    }

    public String func_225594_i_() {
        return this.modid + ":" + this.folder;
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return stage.func_216872_a((Object)Unit.INSTANCE).thenRunAsync(() -> {
            reloadProfiler.func_219894_a();
            reloadProfiler.func_194340_a(this::func_225594_i_);
            this.load(resourceManager);
            reloadProfiler.func_76319_b();
            reloadProfiler.func_219897_b();
        }, gameExecutor);
    }

    private void load(IResourceManager resourceManager) {
        HashMap<VLID, Object> loading = new HashMap<VLID, Object>();
        String location = this.modid + "/" + this.folder;
        for (ResourceLocation file : resourceManager.func_199003_a(location, f -> f.endsWith(this.fileExtension))) {
            VLID id = new VLID(file.func_110624_b(), file.func_110623_a().substring(location.length() + 1, file.func_110623_a().length() - this.fileExtension.length()));
            try {
                for (IResource resource : resourceManager.func_199004_b(file)) {
                    Object data;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_199027_b()));
                        data = this.gson.fromJson((Reader)reader, this.dataClass);
                    }
                    catch (JsonParseException ex) {
                        continue;
                    }
                    if (data != null) {
                        loading.merge(id, data, (arg_0, arg_1) -> this.registry.merge(arg_0, arg_1));
                    }
                    IOUtils.closeQuietly((Closeable)resource);
                }
            }
            catch (IOException e) {
                this.handleException(id, e);
            }
        }
        this.registry.reloadData(loading);
    }

    protected abstract void handleException(VLID var1, Exception var2);
}

