/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.infotablet.client.button;

import com.valkyrieofnight.vlib.core.infotablet.client.InfoTabletDisplay;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizableBGElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.ContainerButtonElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.image.MaxScaledImageElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.text.LabelElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.HAlignment;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.VAlignment;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action1a;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;

public class MainMenuButton
extends ContainerButtonElement {
    private InfoTabletDisplay.MainIndex mainIndex = null;
    private VLID guideID;
    private Action1a<VLID> onPressedAction;
    private SizableBGElement bg;
    private MaxScaledImageElement icon;
    private LabelElement title;
    private SizableBGElement bgMO;
    private MaxScaledImageElement iconMO;
    private LabelElement titleMO;
    private SizableBGElement bgDisabled;
    private MaxScaledImageElement iconDisabled;
    private LabelElement titleDisabled;

    public MainMenuButton(String id, AssetID backgroundGSB, AssetID icon, ITextComponent title, AssetID titleColor) {
        super(id, 120, 58);
        int iw = this.xSize - 8;
        Minecraft.func_71410_x().field_71466_p.getClass();
        int ih = this.ySize - 9 - 2;
        this.bg = new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_ENA);
        this.icon = new MaxScaledImageElement("icon", icon, iw, ih);
        this.icon.setHorizontalAlignment(HAlignment.CENTER);
        this.icon.setVerticalAlignment(VAlignment.CENTER);
        this.title = new LabelElement("title", title, titleColor);
        this.title.setHorizontalAlignment(HAlignment.CENTER);
        this.title.setVerticalAlignment(VAlignment.BOTTOM);
        this.bgMO = new SizableBGElement("bgmo", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_HOV);
        this.iconMO = new MaxScaledImageElement("iconmo", icon, iw, ih);
        this.iconMO.setHorizontalAlignment(HAlignment.CENTER);
        this.iconMO.setVerticalAlignment(VAlignment.CENTER);
        this.titleMO = new LabelElement("titlemo", title, titleColor);
        this.titleMO.setHorizontalAlignment(HAlignment.CENTER);
        this.titleMO.setVerticalAlignment(VAlignment.BOTTOM);
        this.bgDisabled = new SizableBGElement("bgd", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_DIS);
        this.iconDisabled = new MaxScaledImageElement("icond", icon, iw, ih);
        this.iconDisabled.setHorizontalAlignment(HAlignment.CENTER);
        this.iconDisabled.setVerticalAlignment(VAlignment.CENTER);
        this.titleDisabled = new LabelElement("titled", title, titleColor);
        this.titleDisabled.setHorizontalAlignment(HAlignment.CENTER);
        this.titleDisabled.setVerticalAlignment(VAlignment.BOTTOM);
    }

    public void setMainIndex(InfoTabletDisplay.MainIndex index) {
        if (this.mainIndex != null) {
            return;
        }
        this.mainIndex = index;
    }

    public void setGuideID(VLID guideID) {
        if (this.guideID != null) {
            return;
        }
        this.guideID = guideID;
    }

    public VLID getGuideID() {
        return this.guideID;
    }

    @Override
    public void addElements() {
        int cx = this.xSize / 2;
        int ty = this.ySize;
        int iy = this.ySize / 2 - 5;
        this.addElementEach(this.bg, this.bgDisabled, this.bgMO, this.bgMO, 0, 0);
        this.addElementEach(this.icon, this.iconDisabled, this.iconMO, this.iconMO, cx, iy);
        this.addElementEach(this.title, this.titleDisabled, this.titleMO, this.titleMO, cx, ty);
    }

    @Override
    public boolean emouseClicked(double mouseX, double mouseY, int mouseButton) {
        return super.emouseClicked(mouseX, mouseY, mouseButton);
    }

    public MainMenuButton setBg(AssetID bg) {
        this.bg.setBox(bg);
        return this;
    }

    public MainMenuButton setBgMo(AssetID bg) {
        this.bgMO.setBox(bg);
        return this;
    }

    public MainMenuButton setBgDisabled(AssetID bg) {
        this.bgDisabled.setBox(bg);
        return this;
    }

    public MainMenuButton setIcon(AssetID n) {
        this.icon.setImage(n);
        return this;
    }

    public MainMenuButton setIconMo(AssetID n) {
        this.iconMO.setImage(n);
        return this;
    }

    public MainMenuButton setIconDisabled(AssetID n) {
        this.iconDisabled.setImage(n);
        return this;
    }

    public MainMenuButton setTextColor(AssetID color) {
        this.title.setColor(color);
        return this;
    }

    public MainMenuButton setTextMoColor(AssetID color) {
        this.titleMO.setColor(color);
        return this;
    }

    public MainMenuButton setTextDisabledColor(AssetID color) {
        this.titleDisabled.setColor(color);
        return this;
    }

    public MainMenuButton setText(ITextComponent text) {
        this.title.setText(text);
        return this;
    }

    public MainMenuButton setTextMo(ITextComponent text) {
        this.titleMO.setText(text);
        return this;
    }

    public MainMenuButton setTextDisabled(ITextComponent text) {
        this.titleDisabled.setText(text);
        return this;
    }
}

