/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.infotablet.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.infotablet.client.IChangePage;
import com.valkyrieofnight.vlib.core.infotablet.client.button.MainMenuButton;
import com.valkyrieofnight.vlib.core.infotablet.client.guide.AbstractGuideConstructor;
import com.valkyrieofnight.vlib.core.infotablet.client.guide.GuideConstructorRegistry;
import com.valkyrieofnight.vlib.core.infotablet.client.page.AbstractInfoTabletIndex;
import com.valkyrieofnight.vlib.core.infotablet.client.page.AbstractInfoTabletPage;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.scroll.ScrollContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GridAlignment;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.Alignment;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action1a;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import java.util.List;
import java.util.Map;

public class InfoTabletDisplay
extends ScrollContainerElement
implements IChangePage {
    private static GuideConstructorRegistry REG;
    private MainIndex mainIndex;

    public InfoTabletDisplay(int screenWidth, int screenHeight) {
        super("display", screenWidth - 2, screenHeight - 2, 6, 27, 1, StandardThemeAssets.TEX_VANILLA_SCROLL_TAB_27X6_H_ENA, StandardThemeAssets.TEX_VANILLA_SCROLL_TAB_27X6_H_DIS, 27, 6, 1, StandardThemeAssets.TEX_VANILLA_SCROLL_TAB_6X27_V_ENA, StandardThemeAssets.TEX_VANILLA_SCROLL_TAB_6X27_V_DIS);
    }

    @Override
    public void addElementsInContainer() {
        this.mainIndex = new MainIndex("index");
        this.addElement(this.mainIndex, 0, 0);
        this.mainIndex.setPageChangeListener(this::onPageChanged);
    }

    private void onPageChanged(IElement newIndex) {
        this.setMaxScroll(newIndex.getSizeX(), newIndex.getSizeY());
        this.resetXScroll();
        this.resetYScroll();
    }

    @Override
    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        super.mouseClickedResponse(element, mouseX, mouseY, mouseButton);
    }

    @Override
    public void setPageChangeListener(Action1a<IElement> newPage) {
    }

    @Override
    public void nextPage() {
        this.mainIndex.nextPage();
    }

    @Override
    public void prevPage() {
        this.mainIndex.prevPage();
    }

    @Override
    public boolean hasNextPage() {
        return this.mainIndex.hasNextPage();
    }

    @Override
    public boolean hasPrevPage() {
        return this.mainIndex.hasPrevPage();
    }

    @Override
    public void homePage() {
        this.mainIndex.homePage();
    }

    @Override
    public boolean hasHomePage() {
        return this.mainIndex.hasHomePage();
    }

    public static class MainMenu
    extends AbstractInfoTabletPage {
        private List<MainMenuButton> menuButtons = Lists.newArrayList();
        private GridAlignment grid = new GridAlignment(120, 58, 1, 1, 3, Alignment.HORIZONTAL);

        public MainMenu() {
            super("main_menu");
        }

        @Override
        public void addElements() {
            for (MainMenuButton button : this.menuButtons) {
                button.setEnabled(true);
                super.addElement(button, 1 + this.grid.getCurrentXOffset(), 1 + this.grid.getCurrentYOffset());
                this.grid.next();
            }
        }

        protected void addButton(MainMenuButton button) {
            this.menuButtons.add(button);
        }

        @Override
        public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
            super.mouseClickedResponse(element, mouseX, mouseY, mouseButton);
        }
    }

    public static class MainIndex
    extends AbstractInfoTabletIndex {
        private Map<VLID, AbstractInfoTabletPage> pageMap = Maps.newHashMap();

        public MainIndex(String id) {
            super(id, new MainMenu());
        }

        @Override
        protected void addPages() {
            MainMenu mm = (MainMenu)this.getMain();
            List<AbstractGuideConstructor> constructors = GuideConstructorRegistry.getInstance().getConstructors();
            for (AbstractGuideConstructor constructor : constructors) {
                VLID id = constructor.getID();
                AbstractInfoTabletPage page = constructor.construct();
                MainMenuButton button = constructor.constructButton();
                if (page == null || button == null || this.pageMap.containsKey(id)) continue;
                this.pageMap.put(id, page);
                button.setMainIndex(this);
                button.setGuideID(id);
                button.setEnabled(true);
                this.addPage(page);
                mm.addButton(button);
            }
        }

        @Override
        public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
            VLID id;
            if (element instanceof MainMenuButton && this.pageMap.containsKey(id = ((MainMenuButton)element).getGuideID())) {
                this.setPage(id.toString());
            }
            super.mouseClickedResponse(element, mouseX, mouseY, mouseButton);
        }
    }
}

