/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mrh0.buildersaddition.BuildersAddition;
import com.mrh0.buildersaddition.config.Config;
import com.mrh0.buildersaddition.container.SpeakerContainer;
import com.mrh0.buildersaddition.midi.IMidiEvent;
import com.mrh0.buildersaddition.network.PlayNotePacket;
import com.mrh0.buildersaddition.network.UpdateDataPacket;
import com.mrh0.buildersaddition.tileentity.SpeakerTileEntity;
import com.mrh0.buildersaddition.util.Notes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SpeakerGui
extends ContainerScreen<SpeakerContainer>
implements IMidiEvent {
    private final SpeakerContainer screenContainer;
    private final SpeakerTileEntity te;
    private static final int SIZE = 16;
    private Button connectBtn;
    private Button helpBtn;
    private Button[] btns;

    public SpeakerGui(SpeakerContainer screenContainer, PlayerInventory inv, ITextComponent tc) {
        super((Container)screenContainer, inv, tc);
        this.screenContainer = screenContainer;
        this.te = (SpeakerTileEntity)Minecraft.func_71410_x().field_71441_e.func_175625_s(screenContainer.pos);
        this.field_146999_f = 384;
        this.field_147000_g = 192;
        if (BuildersAddition.midi != null) {
            BuildersAddition.midi.midiEvent = this;
        }
    }

    public void func_231158_b_(Minecraft p_231158_1_, int p_231158_2_, int p_231158_3_) {
        super.func_231158_b_(p_231158_1_, p_231158_2_, p_231158_3_);
        int x = this.field_230708_k_ / 2;
        int y = this.field_230709_l_ / 2;
        Button.IPressable p = b -> {};
        this.connectBtn = new Button(x - 48 - 12, y + 96, 96, 20, (ITextComponent)new TranslationTextComponent(BuildersAddition.midi == null ? "container.buildersaddition.speaker.connect" : "container.buildersaddition.speaker.disconnect"), b -> {
            if (BuildersAddition.midi != null) {
                BuildersAddition.midi.midiEvent = BuildersAddition.midi.midiEvent == null ? this : null;
                this.connectBtn.func_238482_a_((ITextComponent)new TranslationTextComponent(BuildersAddition.midi.midiEvent == null ? "container.buildersaddition.speaker.connect" : "container.buildersaddition.speaker.disconnect"));
            }
        });
        this.helpBtn = new Button(x + 52 - 12, y + 96, 20, 20, (ITextComponent)new StringTextComponent("?"), b -> {});
        this.func_230480_a_((Widget)this.connectBtn);
        this.func_230480_a_((Widget)this.helpBtn);
        this.btns = new Button[16];
        for (int i = 0; i < 16; ++i) {
            this.btns[i] = new Button(x + (i > 7 ? -100 : 4), y + i % 8 * 24 - 96, 96, 20, (ITextComponent)new TranslationTextComponent("note.buildersaddition." + Notes.instrumentNames[i]), p);
            this.func_230480_a_((Widget)this.btns[i]);
            this.btns[i].field_230693_o_ = this.te.isInstrumentActive(i);
        }
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        for (int i = 0; i < 16; ++i) {
            if (!this.btns[i].func_230449_g_()) continue;
            this.buttonClicked(this.btns[i], i);
        }
        return super.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    private void buttonClicked(Button b, int id) {
        b.field_230693_o_ = !b.field_230693_o_;
        this.sendInstrumentUpdate(this.getEncoded());
    }

    private int getEncoded() {
        int r = 0;
        for (int i = 0; i < 16; ++i) {
            r = (int)((double)r + (this.btns[i].field_230693_o_ ? Math.pow(2.0, i) : 0.0));
        }
        return r;
    }

    private void sendInstrumentUpdate(int data) {
        if (this.getTE() != null) {
            BuildersAddition.Network.sendToServer((Object)new UpdateDataPacket(this.getTE().func_174877_v(), data));
        }
    }

    public void func_230430_a_(MatrixStack stack, int x, int y, float p_230430_4_) {
        super.func_230430_a_(stack, x, y, p_230430_4_);
        GlStateManager.func_227722_g_();
        GlStateManager.func_227737_l_();
        for (int i = 0; i < 16; ++i) {
            if (!this.btns[i].func_230449_g_()) continue;
            this.func_238652_a_(stack, (ITextComponent)new StringTextComponent("F#" + Notes.octaveNames[i]), x, y);
        }
        if (this.helpBtn.func_230449_g_()) {
            this.func_238652_a_(stack, (ITextComponent)new StringTextComponent((this.hasDevice() ? "Device Discovered" : "No Device Connected") + ", Midi Input: " + ((Boolean)Config.MIDI_INPUT_ENABLED.get() != false ? "Enabled" : "Disabled")), x, y);
        }
        this.func_230459_a_(stack, x, y);
    }

    private boolean hasDevice() {
        if (BuildersAddition.midi != null) {
            return BuildersAddition.midi.hasDevice();
        }
        return false;
    }

    public TileEntity getTE() {
        return this.te;
    }

    private void sendNote(int note) {
        if (this.getTE() != null) {
            BuildersAddition.Network.sendToServer((Object)new PlayNotePacket(this.getTE().func_174877_v(), note));
        }
    }

    @Override
    public void minecraftNote(int note, boolean on) {
        if ((note += 24) < 0) {
            return;
        }
        if (on) {
            this.sendNote(note);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
    }

    protected void func_230450_a_(MatrixStack stack, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
        this.func_230446_a_(stack);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

