/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.VerticalRedstoneDiodeBlock;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ComparatorMode;
import net.minecraft.tileentity.ComparatorTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class VerticalComparatorBlock
extends VerticalRedstoneDiodeBlock {
    public static final EnumProperty<ComparatorMode> MODE = BlockStateProperties.field_208141_ap;

    public VerticalComparatorBlock() {
        super("vertical_comparator", AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196633_cV));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)VERTICAL_FACING, (Comparable)Direction.UP)).func_206870_a((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a(MODE, (Comparable)ComparatorMode.COMPARE));
    }

    @Override
    protected int getDelay(BlockState state) {
        return 2;
    }

    @Override
    protected int getActiveSignal(IBlockReader worldIn, BlockPos pos, BlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof ComparatorTileEntity ? ((ComparatorTileEntity)tileentity).func_145996_a() : 0;
    }

    private int calculateOutput(World worldIn, BlockPos pos, BlockState state) {
        return state.func_177229_b(MODE) == ComparatorMode.SUBTRACT ? Math.max(this.calculateInputStrength(worldIn, pos, state) - this.getPowerOnSides((IWorldReader)worldIn, pos, state), 0) : this.calculateInputStrength(worldIn, pos, state);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = super.func_196258_a(context);
        return (BlockState)blockstate.func_206870_a(MODE, (Comparable)ComparatorMode.COMPARE);
    }

    @Override
    protected boolean shouldBePowered(World worldIn, BlockPos pos, BlockState state) {
        int i = this.calculateInputStrength(worldIn, pos, state);
        if (i == 0) {
            return false;
        }
        int j = this.getPowerOnSides((IWorldReader)worldIn, pos, state);
        if (i > j) {
            return true;
        }
        return i == j && state.func_177229_b(MODE) == ComparatorMode.COMPARE;
    }

    @Override
    protected int calculateInputStrength(World worldIn, BlockPos pos, BlockState state) {
        int i = super.calculateInputStrength(worldIn, pos, state);
        Direction direction = (Direction)state.func_177229_b((Property)VERTICAL_FACING);
        BlockPos blockpos = pos.func_177972_a(direction);
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_185912_n()) {
            i = blockstate.func_185888_a(worldIn, blockpos);
        } else if (i < 15 && blockstate.func_215686_e((IBlockReader)worldIn, blockpos)) {
            blockpos = blockpos.func_177972_a(direction);
            blockstate = worldIn.func_180495_p(blockpos);
            ItemFrameEntity itemframeentity = this.findItemFrame(worldIn, direction, blockpos);
            int j = Math.max(itemframeentity == null ? Integer.MIN_VALUE : itemframeentity.func_174866_q(), blockstate.func_185912_n() ? blockstate.func_185888_a(worldIn, blockpos) : Integer.MIN_VALUE);
            if (j != Integer.MIN_VALUE) {
                i = j;
            }
        }
        return i;
    }

    @Nullable
    private ItemFrameEntity findItemFrame(World worldIn, Direction facing, BlockPos pos) {
        List list = worldIn.func_175647_a(ItemFrameEntity.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)), itemFrame -> itemFrame != null);
        return list.size() == 1 ? (ItemFrameEntity)list.get(0) : null;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!player.field_71075_bZ.field_75099_e) {
            return ActionResultType.PASS;
        }
        float f = (state = (BlockState)state.func_235896_a_(MODE)).func_177229_b(MODE) == ComparatorMode.SUBTRACT ? 0.55f : 0.5f;
        worldIn.func_184133_a(player, pos, SoundEvents.field_187556_aj, SoundCategory.BLOCKS, 0.3f, f);
        worldIn.func_180501_a(pos, state, 2);
        this.onStateChange(worldIn, pos, state);
        return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
    }

    @Override
    protected void updateState(World worldIn, BlockPos pos, BlockState state) {
        if (!worldIn.func_205220_G_().func_205361_b(pos, (Object)this)) {
            int j;
            int i = this.calculateOutput(worldIn, pos, state);
            TileEntity tileentity = worldIn.func_175625_s(pos);
            int n = j = tileentity instanceof ComparatorTileEntity ? ((ComparatorTileEntity)tileentity).func_145996_a() : 0;
            if (i != j || ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue() != this.shouldBePowered(worldIn, pos, state)) {
                TickPriority tickpriority = this.isFacingTowardsRepeater((IBlockReader)worldIn, pos, state) ? TickPriority.HIGH : TickPriority.NORMAL;
                worldIn.func_205220_G_().func_205362_a(pos, (Object)this, 2, tickpriority);
            }
        }
    }

    private void onStateChange(World worldIn, BlockPos pos, BlockState state) {
        int i = this.calculateOutput(worldIn, pos, state);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        int j = 0;
        if (tileentity instanceof ComparatorTileEntity) {
            ComparatorTileEntity comparatortileentity = (ComparatorTileEntity)tileentity;
            j = comparatortileentity.func_145996_a();
            comparatortileentity.func_145995_a(i);
        }
        if (j != i || state.func_177229_b(MODE) == ComparatorMode.COMPARE) {
            boolean flag1 = this.shouldBePowered(worldIn, pos, state);
            boolean flag = (Boolean)state.func_177229_b((Property)POWERED);
            if (flag && !flag1) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
            } else if (!flag && flag1) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            }
            this.notifyNeighbors(worldIn, pos, state);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)Items.field_222029_iU);
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        this.onStateChange((World)worldIn, pos, state);
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ComparatorTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HORIZONTAL_FACING, VERTICAL_FACING, MODE, POWERED});
    }

    public boolean getWeakChanges(BlockState state, IWorldReader world, BlockPos pos) {
        return state.func_203425_a(Blocks.field_196762_fd);
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        if (pos.func_177956_o() == neighbor.func_177956_o() && world instanceof World && !((World)world).func_201670_d()) {
            state.func_215697_a((World)world, pos, world.func_180495_p(neighbor).func_177230_c(), neighbor, false);
        }
    }
}

