/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.sounddeviceoptions.client;

import ichttt.mods.sounddeviceoptions.SDOConfig;
import ichttt.mods.sounddeviceoptions.SoundDeviceOptions;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALUtil;

public class SoundDevices {
    public static final List<String> VALID_DEVICES = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadDeviceList() {
        List<String> list = VALID_DEVICES;
        synchronized (list) {
            boolean success = false;
            try {
                SoundDevices.reloadDeviceList0();
                success = true;
            }
            catch (UnsatisfiedLinkError e) {
                SoundDeviceOptions.LOGGER.error("Failed to reload device list! Native lib not hooked!", (Throwable)e);
            }
            catch (RuntimeException e) {
                SoundDeviceOptions.LOGGER.error("Failed to reload device list! Unexpected error!", (Throwable)e);
            }
            if (!success) {
                VALID_DEVICES.clear();
            }
        }
    }

    private static void reloadDeviceList0() {
        VALID_DEVICES.clear();
        if (ALC10.alcIsExtensionPresent((long)0L, (CharSequence)"ALC_enumerate_all_EXT")) {
            SoundDeviceOptions.LOGGER.debug("Reading sound devices");
            List devices = ALUtil.getStringList((long)0L, (int)4115);
            if (devices == null) {
                SoundDeviceOptions.LOGGER.error("Got null from devices list!");
                return;
            }
            for (String deviceName : devices) {
                boolean success;
                int code;
                String error = null;
                long device = ALC10.alcOpenDevice((CharSequence)deviceName);
                if (device == 0L) {
                    error = "null device";
                }
                if ((code = ALC10.alcGetError((long)device)) != 0) {
                    error = code + "";
                }
                if (device != 0L && !(success = ALC10.alcCloseDevice((long)device))) {
                    error = "Could not close";
                }
                if (error != null) {
                    SoundDeviceOptions.LOGGER.error("Error testing device " + deviceName);
                    SoundDeviceOptions.LOGGER.error("Error code: " + error);
                    continue;
                }
                SoundDeviceOptions.LOGGER.debug("Found valid device " + deviceName);
                VALID_DEVICES.add(deviceName);
            }
        } else {
            SoundDeviceOptions.LOGGER.warn("Could not list devices - operation not supported by sound driver!");
        }
    }

    public static boolean validateActiveOutput(String output) {
        return output == null || VALID_DEVICES.contains(output);
    }

    public static void updateOutput(String newValue) {
        if (newValue == null) {
            newValue = "";
        }
        SDOConfig.CLIENT.activeSoundDevice.set((Object)newValue);
        SDOConfig.CLIENT.activeSoundDevice.save();
    }
}

