/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.test;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yogpc.qp.machines.base.APowerTile;
import com.yogpc.qp.machines.workbench.EnchantmentCopyRecipe;
import com.yogpc.qp.machines.workbench.EnchantmentCopyRecipe$;
import com.yogpc.qp.machines.workbench.IngredientWithCount;
import com.yogpc.qp.machines.workbench.WorkbenchRecipes;
import com.yogpc.qp.machines.workbench.WorkbenchRecipes$;
import com.yogpc.qp.machines.workbench.WorkbenchRecipes$Serializer$;
import com.yogpc.qp.utils.Holder$;
import io.netty.buffer.Unpooled;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.javaapi.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\r4Q\u0001D\u0007\u0003\u001bUAQ\u0001\b\u0001\u0005\u0002yAa!\t\u0001!\n\u0013\u0011\u0003b\u0002\u001e\u0001\u0005\u0004%\ta\u000f\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u001f\t\u000b\u0015\u0003A\u0011\u0001$\t\u000b]\u0003A\u0011\u0001$\t\u000be\u0003A\u0011\u0001$\t\u000bm\u0003A\u0011\u0001$\t\u000bu\u0003A\u0011\u0001$\t\u000b}\u0003A\u0011\u0001$\t\u000b\u0005\u0004A\u0011\u0001$\u0003\u0015I+7-\u001b9f)\u0016\u001cHO\u0003\u0002\u000f\u001f\u0005!A/Z:u\u0015\t\u0001\u0012#\u0001\u0002ra*\u0011!cE\u0001\u0006s><\u0007o\u0019\u0006\u0002)\u0005\u00191m\\7\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005i\u0011AA5e)\t\u0019S\u0006\u0005\u0002%W5\tQE\u0003\u0002'O\u0005!Q\u000f^5m\u0015\tA\u0013&A\u0005nS:,7M]1gi*\t!&A\u0002oKRL!\u0001L\u0013\u0003!I+7o\\;sG\u0016dunY1uS>t\u0007\"\u0002\u0018\u0003\u0001\u0004y\u0013!A:\u0011\u0005A:dBA\u00196!\t\u0011\u0004$D\u00014\u0015\t!T$\u0001\u0004=e>|GOP\u0005\u0003ma\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011a\u0007G\u0001\u0005UN|g.F\u0001=!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0003hg>t'BA!\u0014\u0003\u00199wn\\4mK&\u00111I\u0010\u0002\u000b\u0015N|gn\u00142kK\u000e$\u0018!\u00026t_:\u0004\u0013!D2p]Z,'\u000f\u001e*fG&\u0004X\rF\u0001H!\t9\u0002*\u0003\u0002J1\t!QK\\5uQ\t)1\n\u0005\u0002M+6\tQJ\u0003\u0002O\u001f\u0006\u0019\u0011\r]5\u000b\u0005A\u000b\u0016a\u00026va&$XM\u001d\u0006\u0003%N\u000bQA[;oSRT\u0011\u0001V\u0001\u0004_J<\u0017B\u0001,N\u0005\u0011!Vm\u001d;\u0002'\r|\u0007/_#oG\"\fg\u000e^7f]R$Vm\u001d;)\u0005\u0019Y\u0015aC2paft%\r\u001e+fgRD#aB&\u0002)\u001d|G/\u0012:s_J4%o\\7O_J+7/\u001e7uQ\tA1*A\tqCJ\u001cXMT8s[\u0006d'+Z2ja\u0016D#!C&\u0002%A\f'o]3O_Jl\u0017\r\u001c*fG&\u0004XM\r\u0015\u0003\u0015-\u000b1bY=dY\u0016\u0004\u0016mY6fi\"\u00121b\u0013")
public final class RecipeTest {
    private final JsonObject json = JSONUtils.func_212745_a((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |{\n      |  \"type\": \"quarryplus:workbench_recipe\",\n      |  \"id\": \"quarryplus:convert_quarry\",\n      |  \"sub_type\": \"copy_enchantment\",\n      |  \"enchantment_from\": {\n      |    \"item\": \"quarryplus:quarryplus\",\n      |    \"count\": 1\n      |  },\n      |  \"ingredients\": [ ],\n      |  \"energy\": 1000.0,\n      |  \"result\": {\n      |    \"item\": \"quarryplus:quarry\",\n      |    \"count\": 1\n      |  },\n      |  \"conditions\": [\n      |    {\n      |      \"value\": \"NewQuarry\",\n      |      \"type\": \"quarryplus:machine_enabled\"\n      |    },\n      |    {\n      |      \"value\": \"QuarryPlus\",\n      |      \"type\": \"quarryplus:machine_enabled\"\n      |    }\n      |  ]\n      |}")));

    private ResourceLocation id(String s) {
        return new ResourceLocation("quarryplus", s.toLowerCase());
    }

    public JsonObject json() {
        return this.json;
    }

    @Test
    public void convertRecipe() {
        WorkbenchRecipes recipes2 = WorkbenchRecipes$Serializer$.MODULE$.read(new ResourceLocation("quarryplus:convert_quarry"), this.json());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)new ResourceLocation("quarryplus:convert_quarry"), (Object)recipes2.func_199560_c()), () -> Assertions.assertTrue((boolean)recipes2.hasContent(), (String)"Valid recipe"), () -> Assertions.assertEquals((Object)Holder$.MODULE$.blockQuarry2().func_199767_j(), (Object)recipes2.getOutput().func_77973_b()), () -> Assertions.assertEquals((int)1, (int)recipes2.getOutput().func_190916_E()), () -> Assertions.assertEquals(EnchantmentCopyRecipe.class, recipes2.getClass(), (String)"Class check"), () -> Assertions.assertEquals((int)1, (int)((SeqOps)recipes2.inputs().head()).size())});
    }

    @Test
    public void copyEnchantmentTest() {
        WorkbenchRecipes recipes2 = WorkbenchRecipes$Serializer$.MODULE$.read(new ResourceLocation("quarryplus:convert_quarry"), this.json());
        ItemStack oldQuarry = new ItemStack((IItemProvider)Holder$.MODULE$.blockQuarry());
        EnchantmentHelper.func_82782_a((java.util.Map)CollectionConverters$.MODULE$.asJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Enchantments.field_185306_r), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Enchantments.field_185305_q), (Object)BoxesRunTime.boxToInteger((int)4))}))), (ItemStack)oldQuarry);
        ItemStack out = recipes2.getOutput(Arrays.asList((Object[])new ItemStack[]{oldQuarry}));
        Assertions.assertFalse((boolean)out.func_190926_b(), (String)"Out is valid item.");
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((int)1, (int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)out), (String)new StringBuilder(13).append("Silktouch in ").append(out).toString()), () -> Assertions.assertEquals((int)4, (int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)out), (String)new StringBuilder(14).append("Efficiency in ").append(out).toString())});
    }

    @Test
    public void copyNbtTest() {
        ItemStack recipeOut = new ItemStack((IItemProvider)Items.field_151034_e);
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("test1", "a");
        recipeOut.func_77982_d(tag);
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        EnchantmentCopyRecipe recipe = new EnchantmentCopyRecipe(this.id("d"), recipeOut, 100L, (Seq<IngredientWithCount>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IngredientWithCount[]{new IngredientWithCount(new ItemStack((IItemProvider)Items.field_221554_G, 4))}))), (Seq<Seq<IngredientWithCount>>)package$.MODULE$.Nil(), EnchantmentCopyRecipe$.MODULE$.$lessinit$greater$default$6());
        List<Object> ins = Arrays.asList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_221554_G, 2), new ItemStack((IItemProvider)Items.field_221554_G, 7)});
        ItemStack o = recipe.getOutput(ins);
        Assertions.assertTrue((boolean)ItemStack.func_77989_b((ItemStack)recipeOut, (ItemStack)o));
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        ItemStack in1 = new ItemStack((IItemProvider)Items.field_221554_G, 2);
        in1.func_77966_a(Enchantments.field_185305_q, 3);
        ItemStack in2 = new ItemStack((IItemProvider)Items.field_221554_G, 7);
        CompoundNBT t = new CompoundNBT();
        t.func_74774_a("test2", (byte)4);
        in2.func_77982_d(t);
        List<Object> ins2 = Arrays.asList((Object[])new ItemStack[]{in1, in2});
        ItemStack o2 = recipe.getOutput(ins2);
        CompoundNBT tag2 = o2.func_77978_p();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)"a", (Object)tag2.func_74779_i("test1")), () -> Assertions.assertEquals((int)4, (int)tag2.func_74771_c("test2"))});
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    @Test
    public void gotErrorFromNoResult() {
        JsonObject noResult = JSONUtils.func_212745_a((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |  \"type\": \"quarryplus:workbench_recipe\",\n        |  \"ingredients\": [\n        |    {\n        |      \"tag\": \"forge:ingots/gold\",\n        |      \"count\": 16\n        |    }\n        |  ],\n        |  \"energy\": 320000.0,\n        |  \"showInJEI\": true\n        |}\n        |")));
        Either<String, WorkbenchRecipes> noResultRecipe = WorkbenchRecipes$.MODULE$.parse(noResult, this.id("no_result"));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertTrue((boolean)noResultRecipe.isLeft(), (String)"no result"), () -> Assertions.assertTrue((boolean)noResultRecipe.left().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("Missing result"))), (String)new StringBuilder(10).append("Exception ").append(noResultRecipe).toString())});
        JsonObject hasEmptyResult = new JsonObject();
        noResult.entrySet().forEach(e -> hasEmptyResult.add((String)e.getKey(), (JsonElement)e.getValue()));
        hasEmptyResult.add("result", (JsonElement)new JsonObject());
        Either<String, WorkbenchRecipes> resultRecipe = WorkbenchRecipes$.MODULE$.parse(hasEmptyResult, this.id("empty_result"));
        Assertions.assertTrue((boolean)resultRecipe.isLeft(), (String)new StringBuilder(13).append("empty result ").append(resultRecipe).toString());
    }

    @Test
    public void parseNormalRecipe() {
        String str = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |  \"type\": \"quarryplus:workbench_recipe\",\n        |  \"id\": \"quarryplus:builtin_item.fuel_module_normal\",\n        |  \"ingredients\": [\n        |    {\n        |      \"item\": \"minecraft:furnace\",\n        |      \"count\": 3\n        |    },\n        |    {\n        |      \"tag\": \"forge:storage_blocks/gold\",\n        |      \"count\": 16\n        |    }\n        |  ],\n        |  \"energy\": 3200.0,\n        |  \"showInJEI\": true,\n        |  \"result\": {\n        |    \"item\": \"quarryplus:fuel_module_normal\",\n        |    \"count\": 1\n        |  },\n        |  \"conditions\": [\n        |    {\n        |      \"value\": \"ModuleFuel\",\n        |      \"type\": \"quarryplus:machine_enabled\"\n        |    }\n        |  ]\n        |}"));
        WorkbenchRecipes recipe = WorkbenchRecipes$Serializer$.MODULE$.read(this.id("fuel"), JSONUtils.func_212745_a((String)str));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((long)(3200L * APowerTile.MJToMicroMJ), (long)recipe.energy())});
    }

    @Test
    public void parseNormalRecipe2() {
        String str = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |  \"type\": \"quarryplus:workbench_recipe\",\n        |  \"id\": \"quarryplus:cheat_diamond\",\n        |  \"ingredients\": [\n        |    {\n        |      \"item\": \"minecraft:dirt\",\n        |      \"count\": 3\n        |    },\n        |    {\n        |      \"item\": \"minecraft:stone\",\n        |      \"count\": 16\n        |    }\n        |  ],\n        |  \"energy\": 100.0,\n        |  \"result\": {\n        |    \"item\": \"diamond\",\n        |    \"count\": 1\n        |  }\n        |}"));
        WorkbenchRecipes recipe = WorkbenchRecipes$Serializer$.MODULE$.read(this.id("cheat_diamond"), JSONUtils.func_212745_a((String)str));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((long)(100L * APowerTile.MJToMicroMJ), (long)recipe.energy()), () -> Assertions.assertTrue((boolean)ItemStack.func_77989_b((ItemStack)new ItemStack((IItemProvider)Items.field_151045_i), (ItemStack)recipe.getOutput()), (String)new StringBuilder(17).append("Recipe output is ").append(recipe.getOutput()).toString()), () -> Assertions.assertTrue((boolean)recipe.showInJEI()), () -> Assertions.assertTrue((boolean)recipe.hasAllRequiredItems((Seq<ItemStack>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_221582_j, 3), new ItemStack((IItemProvider)Items.field_221574_b, 16)}))))), () -> Assertions.assertFalse((boolean)recipe.hasAllRequiredItems((Seq<ItemStack>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_221582_j, 2), new ItemStack((IItemProvider)Items.field_221574_b, 16)}))))), () -> Assertions.assertFalse((boolean)recipe.hasAllRequiredItems((Seq<ItemStack>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_221582_j, 3), new ItemStack((IItemProvider)Items.field_221574_b, 15)}))))), () -> Assertions.assertFalse((boolean)recipe.hasAllRequiredItems((Seq<ItemStack>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_221582_j, 3)}))))), () -> Assertions.assertFalse((boolean)recipe.hasAllRequiredItems((Seq<ItemStack>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_221574_b, 16)})))))});
    }

    @Test
    public void cyclePacket() {
        String str = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |  \"type\": \"quarryplus:workbench_recipe\",\n        |  \"id\": \"quarryplus:cheat_diamond2\",\n        |  \"ingredients\": [\n        |    {\n        |      \"item\": \"minecraft:stone\",\n        |      \"count\": 130\n        |    },\n        |    {\n        |      \"item\": \"minecraft:coal\",\n        |      \"count\": 256\n        |    }\n        |  ],\n        |  \"energy\": 100.0,\n        |  \"result\": {\n        |    \"item\": \"diamond\",\n        |    \"count\": 1\n        |  }\n        |}"));
        WorkbenchRecipes recipe = WorkbenchRecipes$Serializer$.MODULE$.read(this.id("cheat_diamond2"), JSONUtils.func_212745_a((String)str));
        Assertions.assertTrue((boolean)ItemStack.func_77989_b((ItemStack)new ItemStack((IItemProvider)Items.field_151045_i), (ItemStack)recipe.getOutput()));
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        WorkbenchRecipes$Serializer$.MODULE$.write(packet, recipe);
        WorkbenchRecipes loaded = WorkbenchRecipes$Serializer$.MODULE$.read(this.id("cheat_diamond2"), packet);
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertTrue((boolean)loaded.hasAllRequiredItems((Seq<ItemStack>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151044_h, 512), new ItemStack((IItemProvider)Items.field_221574_b, 512)}))))), () -> Assertions.assertTrue((boolean)loaded.hasAllRequiredItems((Seq<ItemStack>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151044_h, 256), new ItemStack((IItemProvider)Items.field_221574_b, 130)}))))), () -> Assertions.assertFalse((boolean)loaded.hasAllRequiredItems((Seq<ItemStack>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151044_h, 255), new ItemStack((IItemProvider)Items.field_221574_b, 128)}))))), () -> Assertions.assertFalse((boolean)loaded.hasAllRequiredItems((Seq<ItemStack>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151044_h, 256), new ItemStack((IItemProvider)Items.field_221574_b, 127)}))))), () -> Assertions.assertFalse((boolean)loaded.hasAllRequiredItems((Seq<ItemStack>)((Seq)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)))), () -> Assertions.assertFalse((boolean)recipe.hasAllRequiredItems((Seq<ItemStack>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_221582_j, 256), new ItemStack((IItemProvider)Items.field_221574_b, 512)})))))});
    }
}

