/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.mover;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.yogpc.qp.machines.base.EnchantmentFilter;
import com.yogpc.qp.machines.base.EnchantmentFilter$Accessor$;
import com.yogpc.qp.machines.base.QuarryBlackList;
import com.yogpc.qp.machines.base.QuarryBlackList$Entry$;
import com.yogpc.qp.packet.IMessage;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import scala.jdk.javaapi.OptionConverters;

public class EnchantmentMessage
implements IMessage<EnchantmentMessage> {
    Type type;
    BlockPos pos;
    ResourceLocation dim;
    Enchantment enchantment;
    QuarryBlackList.Entry entry;

    public static EnchantmentMessage create(EnchantmentFilter.Accessor tile, Type type, Enchantment enchantment, QuarryBlackList.Entry entry) {
        EnchantmentMessage message = new EnchantmentMessage();
        message.pos = tile.getPos();
        message.dim = IMessage.getDimId(tile.getWorld());
        message.type = type;
        message.enchantment = enchantment;
        message.entry = entry;
        return message;
    }

    @Override
    public EnchantmentMessage readFromBuffer(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.type = (Type)buffer.func_179257_a(Type.class);
        this.enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(buffer.func_192575_l());
        this.entry = QuarryBlackList.readEntry(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)buffer.func_150793_b()));
        this.dim = buffer.func_192575_l();
        return this;
    }

    @Override
    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).func_179249_a((Enum)this.type).func_192572_a(Objects.requireNonNull(this.enchantment.getRegistryName())).func_150786_a((CompoundNBT)QuarryBlackList$Entry$.MODULE$.EntryToNBT().apply((Object)this.entry)).func_192572_a(this.dim);
    }

    @Override
    public void onReceive(Supplier<NetworkEvent.Context> ctx) {
        IMessage.findTile(ctx, this.pos, this.dim, TileEntity.class).flatMap(t -> OptionConverters.toJava(EnchantmentFilter$Accessor$.MODULE$.apply((TileEntity)t))).ifPresent(tile -> ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> {
            if (this.type == Type.Toggle) {
                if (this.enchantment == Enchantments.field_185308_t) {
                    tile.enchantmentFilter_$eq(tile.enchantmentFilter().toggleFortune());
                } else if (this.enchantment == Enchantments.field_185306_r) {
                    tile.enchantmentFilter_$eq(tile.enchantmentFilter().toggleSilktouch());
                }
            } else if (this.type == Type.Remove) {
                if (this.enchantment == Enchantments.field_185308_t) {
                    tile.enchantmentFilter_$eq(tile.enchantmentFilter().removeFortune(this.entry));
                } else if (this.enchantment == Enchantments.field_185306_r) {
                    tile.enchantmentFilter_$eq(tile.enchantmentFilter().removeSilktouch(this.entry));
                }
            }
        }));
    }

    public static enum Type {
        Toggle,
        Remove;

    }
}

