/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.controller;

import com.yogpc.qp.machines.controller.GuiController;
import com.yogpc.qp.packet.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.EntityType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AvailableEntities
implements IMessage<AvailableEntities> {
    BlockPos pos;
    ResourceLocation dim;
    List<ResourceLocation> entities;

    public static AvailableEntities create(BlockPos pos, World world, List<EntityType<?>> list) {
        AvailableEntities availableEntities = new AvailableEntities();
        availableEntities.pos = pos;
        availableEntities.entities = list.stream().map(ForgeRegistryEntry::getRegistryName).collect(Collectors.toList());
        availableEntities.dim = IMessage.getDimId(world);
        return availableEntities;
    }

    @Override
    public AvailableEntities readFromBuffer(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.dim = buffer.func_192575_l();
        int i = buffer.readInt();
        this.entities = new ArrayList<ResourceLocation>(i);
        for (int j = 0; j < i; ++j) {
            this.entities.add(buffer.func_192575_l());
        }
        return this;
    }

    @Override
    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.func_192572_a(this.dim);
        buffer.writeInt(this.entities.size());
        this.entities.forEach(arg_0 -> ((PacketBuffer)buffer).func_192572_a(arg_0));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onReceive(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Minecraft.func_71410_x().func_147108_a((Screen)new GuiController(this.dim, this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p(), this.entities)));
    }
}

